/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;
import com.bringspring.system.permission.mapper.OrganizeAdminIsTratorMapper;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganizeAdministratorServiceImpl
extends ServiceImpl<OrganizeAdminIsTratorMapper, OrganizeAdministratorEntity>
implements OrganizeAdministratorService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public OrganizeAdministratorEntity getOne(String userId, String organizeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(OrganizeAdministratorEntity::getUserId, (Object)userId);
        queryWrapper.lambda().eq(OrganizeAdministratorEntity::getOrganizeId, (Object)organizeId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(OrganizeAdministratorEntity::getSortCode)).orderByDesc(OrganizeAdministratorEntity::getCreatorTime);
        return (OrganizeAdministratorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<OrganizeAdministratorEntity> getOrganizeAdministratorEntity(String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(OrganizeAdministratorEntity::getUserId, (Object)userId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(OrganizeAdministratorEntity::getSortCode)).orderByDesc(OrganizeAdministratorEntity::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public void create(OrganizeAdministratorEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String organizeId, OrganizeAdministratorEntity entity) {
        entity.setId(entity.getId());
        entity.setLastModifyTime(DateUtil.getNowDate());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public OrganizeAdministratorEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeAdministratorEntity::getId, (Object)id);
        return (OrganizeAdministratorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(OrganizeAdministratorEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public OrganizeAdministratorEntity getInfoByOrganizeId(String organizeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeAdministratorEntity::getOrganizeId, (Object)organizeId);
        return (OrganizeAdministratorEntity)this.getOne((Wrapper)queryWrapper);
    }
}

