/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.Page;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.entity.GroupEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.organize.OrganizeListVO;
import com.bringspring.system.permission.model.user.mod.RangeElementModel;
import com.bringspring.system.permission.model.user.vo.RangeElementSelectorVO;
import com.bringspring.system.permission.model.user.vo.UserSelectorVO;
import com.bringspring.system.permission.service.GroupService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RangeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DSTransactional
public class RangeServiceImpl
implements RangeService {
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;

    @Override
    public Map<String, Object> getRangeElementSelected(List<RangeElementModel> selected) {
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        if (CollectionUtil.isNotEmpty(selected)) {
            block18: for (int i = 0; i < selected.size(); ++i) {
                RangeElementModel rangeElementModel = selected.get(i);
                String type = rangeElementModel.getType();
                String[] selectArr = rangeElementModel.getSelectArr();
                List<String> idList = Arrays.asList(selectArr);
                switch (type) {
                    case "company": {
                        List<OrganizeEntity> companyList = this.organizeService.getOrgEntityList(idList, true);
                        typeMap.put(type, companyList);
                        continue block18;
                    }
                    case "department": {
                        List<OrganizeEntity> departmentList = this.organizeService.getOrgEntityList(idList, true);
                        typeMap.put(type, departmentList);
                        continue block18;
                    }
                    case "user": {
                        List<UserEntity> userList = this.userService.getUserByIds(idList);
                        typeMap.put(type, userList);
                        continue block18;
                    }
                    case "Role": {
                        List<RoleEntity> roleList = this.roleService.getListByIds(idList);
                        typeMap.put(type, roleList);
                        continue block18;
                    }
                    case "Position": {
                        List<PositionEntity> positionList = this.positionService.getListByIds(idList);
                        typeMap.put(type, positionList);
                        continue block18;
                    }
                    case "Group": {
                        List<GroupEntity> groupList = this.groupService.getListByIds(idList);
                        typeMap.put(type, groupList);
                        continue block18;
                    }
                    case "exclude": {
                        List<UserEntity> excludeList = this.userService.getUserByIds(idList);
                        typeMap.put(type, excludeList);
                        continue block18;
                    }
                }
            }
        }
        return typeMap;
    }

    @Override
    public List<UserEntity> getRangeElementUserList(List<RangeElementModel> selected) {
        HashSet userIds = new HashSet();
        Set<Object> excludeUserIds = new HashSet();
        Map<String, Object> rangeElementSelected = this.getRangeElementSelected(selected);
        if (CollectionUtil.isNotEmpty(rangeElementSelected)) {
            for (Map.Entry<String, Object> entry : rangeElementSelected.entrySet()) {
                List excludeList;
                List groupList;
                List<UserRelationEntity> relationList;
                List<String> objectIdList;
                List positionList;
                List roleList;
                List userList;
                Set userIdList;
                List departmentList;
                List companys;
                String type = entry.getKey();
                if ("company".equals(type) && CollectionUtil.isNotEmpty((Collection)(companys = (List)entry.getValue()))) {
                    List<String> companyIds = companys.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
                    List<OrganizeEntity> listByCompanyIds = this.organizeService.getListByCompanyIds(companyIds);
                    List<String> orgIds = listByCompanyIds.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
                    List<UserEntity> userByOrgIds = this.userService.getUserByOrgIds(orgIds);
                    Set userIdList2 = userByOrgIds.stream().map(UserEntity::getId).collect(Collectors.toSet());
                    userIds.addAll(userIdList2);
                }
                if ("department".equals(type) && CollectionUtil.isNotEmpty((Collection)(departmentList = (List)entry.getValue()))) {
                    List<String> orgIds = departmentList.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
                    List<UserEntity> userByOrgIds = this.userService.getUserByOrgIds(orgIds);
                    userIdList = userByOrgIds.stream().map(UserEntity::getId).collect(Collectors.toSet());
                    userIds.addAll(userIdList);
                }
                if ("user".equals(type) && CollectionUtil.isNotEmpty((Collection)(userList = (List)entry.getValue()))) {
                    Set userIdList3 = userList.stream().map(UserEntity::getId).collect(Collectors.toSet());
                    userIds.addAll(userIdList3);
                }
                if ("Role".equals(type) && CollectionUtil.isNotEmpty((Collection)(roleList = (List)entry.getValue()))) {
                    for (RoleEntity entity : roleList) {
                        List<UserEntity> userListByRoleId = this.userService.getUserListByRoleId(entity.getId());
                        Set userIdList4 = userListByRoleId.stream().map(UserEntity::getId).collect(Collectors.toSet());
                        userIds.addAll(userIdList4);
                    }
                }
                if ("Position".equals(type) && CollectionUtil.isNotEmpty((Collection)(positionList = (List)entry.getValue()))) {
                    objectIdList = positionList.stream().map(PermissionEntityBase::getId).collect(Collectors.toList());
                    relationList = this.userRelationService.getListByObjectIdAll(objectIdList);
                    userIdList = relationList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toSet());
                    userIds.addAll(userIdList);
                }
                if ("Group".equals(type) && CollectionUtil.isNotEmpty((Collection)(groupList = (List)entry.getValue()))) {
                    objectIdList = groupList.stream().map(GroupEntity::getId).collect(Collectors.toList());
                    relationList = this.userRelationService.getListByObjectIdAll(objectIdList);
                    userIdList = relationList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toSet());
                    userIds.addAll(userIdList);
                }
                if (!"exclude".equals(type) || !CollectionUtil.isNotEmpty((Collection)(excludeList = (List)entry.getValue()))) continue;
                excludeUserIds = excludeList.stream().map(UserEntity::getId).collect(Collectors.toSet());
            }
        }
        userIds.removeAll(excludeUserIds);
        List<UserEntity> list = new ArrayList<UserEntity>();
        if (CollectionUtil.isNotEmpty(userIds)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getId, userIds);
            list = this.userService.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<RangeElementSelectorVO> getOrganizeUserList(String tab, Page page) {
        OrganizeEntity company;
        OrganizeEntity organize;
        OrganizeRelationEntity organizeRelation;
        List<OrganizeRelationEntity> relList;
        RangeElementSelectorVO vo;
        ArrayList<RangeElementSelectorVO> organizeUserList = new ArrayList<RangeElementSelectorVO>();
        List<OrganizeEntity> allOrganize = this.organizeService.getList();
        List<OrganizeEntity> companyList = allOrganize.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        String keyword = page.getKeyword();
        if ("Organize".equals(tab)) {
            if (StringUtils.isNotEmpty((String)keyword)) {
                List organizeList = allOrganize.stream().filter(t -> t.getFullName().contains(keyword)).collect(Collectors.toList());
                for (OrganizeEntity organizeEntity : organizeList) {
                    vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)organizeEntity, RangeElementSelectorVO.class);
                    if ("department".equals(vo.getType())) {
                        vo.setIcon("icon-ym icon-ym-tree-department1");
                    } else if ("company".equals(vo.getType())) {
                        vo.setIcon("icon-ym icon-ym-tree-organization3");
                    }
                    vo.setHasChildren(false);
                    vo.setIsLeaf(true);
                    vo.setEnabledMark(1);
                    if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                        OrganizeEntity company2 = companyList.stream().filter(t -> t.getId().equals(vo.getCompanyId())).findFirst().orElse(null);
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company2.getShortName()) ? company2.getShortName() : company2.getFullName());
                    }
                    organizeUserList.add(vo);
                }
                List<UserEntity> userList = this.userService.getList(keyword);
                for (UserEntity entity : userList) {
                    RangeElementSelectorVO vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(entity.getId());
                    vo2.setParentId(entity.getOrganizeId());
                    vo2.setFullName(entity.getRealName());
                    vo2.setHeadIcon(entity.getHeadIcon());
                    vo2.setType("user");
                    vo2.setIcon("icon-ym icon-ym-tree-user2");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    OrganizeEntity organize3 = allOrganize.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty((Object)organize3)) {
                        OrganizeEntity company3;
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize3.getShortName()) ? organize3.getShortName() : organize3.getFullName());
                        if (StringUtils.isNotEmpty((String)organize3.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company3 = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize3.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company3.getShortName()) ? company3.getShortName() : company3.getFullName());
                        }
                    }
                    if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                        List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                        List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                        String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                        vo2.setPositionName(positionNames);
                    }
                    organizeUserList.add(vo2);
                }
            } else {
                List<OrganizeListVO> organizeListTree = this.getOrganizeListTree("-1", allOrganize);
                List<UserEntity> allUser = this.userService.getList();
                if (CollectionUtil.isNotEmpty(organizeListTree)) {
                    List list = JsonUtil.getJsonToList(organizeListTree, RangeElementSelectorVO.class);
                    this.recursionSettingUser(list, allUser, companyList);
                    organizeUserList.addAll(list);
                }
            }
        }
        if ("Role".equals(tab)) {
            List<RoleEntity> roleList = this.roleService.getList(keyword);
            for (RoleEntity roleEntity : roleList) {
                vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)roleEntity, RangeElementSelectorVO.class);
                vo.setId(roleEntity.getId());
                vo.setType("Role");
                vo.setIcon("icon-ym icon-ym-role");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                relList = this.organizeRelationService.getRelationListByRoleId(roleEntity.getId());
                OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                    vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                    if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                    }
                }
                organizeUserList.add(vo);
            }
        }
        if ("Position".equals(tab)) {
            List<PositionEntity> positionList = this.positionService.getList(keyword);
            for (PositionEntity positionEntity : positionList) {
                vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)positionEntity, RangeElementSelectorVO.class);
                vo.setId(positionEntity.getId());
                vo.setType("Position");
                vo.setIcon("icon-ym icon-ym-position");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                relList = this.organizeRelationService.getRelationListByObjectIdAndType("Position", positionEntity.getId());
                OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                    vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                    if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                    }
                }
                organizeUserList.add(vo);
            }
        }
        if ("Group".equals(tab)) {
            List<GroupEntity> groupList = this.groupService.list(keyword);
            for (GroupEntity groupEntity : groupList) {
                vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)groupEntity, RangeElementSelectorVO.class);
                vo.setId(groupEntity.getId());
                vo.setType("Group");
                vo.setIcon("icon-ym icon-ym-group");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                organizeUserList.add(vo);
            }
        }
        return organizeUserList;
    }

    private List<OrganizeListVO> getOrganizeListTree(String parentId, List<OrganizeEntity> allOrganize) {
        List listByParentId = allOrganize.stream().filter(t -> t.getParentId().equals(parentId)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(listByParentId)) {
            List listVO = JsonUtil.getJsonToList(listByParentId, OrganizeListVO.class);
            this.recursionOrganizeTree(listVO, allOrganize);
            return listVO;
        }
        return null;
    }

    private void recursionOrganizeTree(List<OrganizeListVO> returnList, List<OrganizeEntity> allOrganize) {
        returnList.stream().forEach(item -> {
            List listChild = allOrganize.stream().filter(t -> t.getParentId().equals(item.getId())).collect(Collectors.toList());
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, OrganizeListVO.class);
            item.setChildren(listVO);
            this.recursionOrganizeTree(listVO, allOrganize);
        });
    }

    private void recursionSettingUser(List<RangeElementSelectorVO> organizeList, List<UserEntity> allUser, List<OrganizeEntity> companyList) {
        if (CollectionUtil.isNotEmpty(organizeList)) {
            for (RangeElementSelectorVO organizeVo : organizeList) {
                List<RangeElementSelectorVO> children;
                if (StringUtils.isNotEmpty((String)organizeVo.getCompanyId())) {
                    OrganizeEntity company = companyList.stream().filter(t -> t.getId().equals(organizeVo.getCompanyId())).findFirst().orElse(null);
                    organizeVo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                }
                if (CollectionUtil.isNotEmpty(children = organizeVo.getChildren())) {
                    this.recursionSettingUser(children, allUser, companyList);
                    organizeVo.setHasChildren(true);
                } else {
                    organizeVo.setHasChildren(false);
                }
                if ("department".equals(organizeVo.getType())) {
                    organizeVo.setIcon("icon-ym icon-ym-tree-department1");
                } else if ("company".equals(organizeVo.getType())) {
                    organizeVo.setIcon("icon-ym icon-ym-tree-organization3");
                }
                List userList = allUser.stream().filter(t -> organizeVo.getId().equals(t.getOrganizeId())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(userList)) {
                    organizeVo.getFullName();
                    if (CollectionUtil.isEmpty(children)) {
                        children = new ArrayList<RangeElementSelectorVO>();
                        organizeVo.setChildren(children);
                        organizeVo.setHasChildren(true);
                    }
                    ArrayList<RangeElementSelectorVO> userVoList = new ArrayList<RangeElementSelectorVO>();
                    for (UserEntity entity : userList) {
                        RangeElementSelectorVO vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                        vo.setId(entity.getId());
                        vo.setParentId(entity.getOrganizeId());
                        vo.setFullName(entity.getRealName());
                        vo.setHeadIcon(entity.getHeadIcon());
                        vo.setType("user");
                        vo.setIcon("icon-ym icon-ym-tree-user2");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);
                        vo.setOrganizeName(organizeVo.getFullName());
                        vo.setCompanyName(organizeVo.getCompanyName());
                        if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                            List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                            List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                            String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                            vo.setPositionName(positionNames);
                        }
                        userVoList.add(vo);
                    }
                    children.addAll(0, userVoList);
                }
                organizeVo.setIsLeaf(organizeVo.getHasChildren() == false);
            }
        }
    }

    @Override
    public List<RangeElementSelectorVO> getOrganizeUserList(List<RangeElementModel> selected) {
        ArrayList<RangeElementSelectorVO> organizeUserList = new ArrayList<RangeElementSelectorVO>();
        List<OrganizeEntity> allOrganize = this.organizeService.getList();
        List companyList = allOrganize.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        Map<String, Object> rangeElementSelected = this.getRangeElementSelected(selected);
        for (Map.Entry<String, Object> entry : rangeElementSelected.entrySet()) {
            List groupList;
            List positionList;
            OrganizeEntity company;
            OrganizeEntity organize;
            OrganizeRelationEntity organizeRelation;
            List<OrganizeRelationEntity> relList;
            List roleList;
            List userList;
            List departmentList;
            RangeElementSelectorVO vo2;
            List companys;
            String type = entry.getKey();
            if ("company".equals(type) && CollectionUtil.isNotEmpty((Collection)(companys = (List)entry.getValue()))) {
                List companyVOList = JsonUtil.getJsonToList((Object)companys, RangeElementSelectorVO.class);
                for (RangeElementSelectorVO vo2 : companyVOList) {
                    vo2.setIcon("icon-ym icon-ym-tree-organization3");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                }
                organizeUserList.addAll(companyVOList);
            }
            if ("department".equals(type) && CollectionUtil.isNotEmpty((Collection)(departmentList = (List)entry.getValue()))) {
                List departmentVOList = JsonUtil.getJsonToList((Object)departmentList, RangeElementSelectorVO.class);
                for (RangeElementSelectorVO vo2 : departmentVOList) {
                    vo2.setIcon("icon-ym icon-ym-tree-department1");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    if (!StringUtils.isNotEmpty((String)vo2.getCompanyId())) continue;
                    OrganizeEntity company2 = companyList.stream().filter(t -> t.getId().equals(vo2.getCompanyId())).findFirst().orElse(null);
                    vo2.setCompanyName(StringUtils.isNotEmpty((String)company2.getShortName()) ? company2.getShortName() : company2.getFullName());
                }
                organizeUserList.addAll(departmentVOList);
            }
            if ("user".equals(type) && CollectionUtil.isNotEmpty((Collection)(userList = (List)entry.getValue()))) {
                for (Object entity : userList) {
                    vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(((UserEntity)entity).getId());
                    vo2.setParentId(((UserEntity)entity).getOrganizeId());
                    vo2.setFullName(((UserEntity)entity).getRealName());
                    vo2.setHeadIcon(((UserEntity)entity).getHeadIcon());
                    vo2.setType("user");
                    vo2.setIcon("icon-ym icon-ym-tree-user2");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    OrganizeEntity organize2 = allOrganize.stream().filter(arg_0 -> RangeServiceImpl.lambda$getOrganizeUserList$16((UserEntity)entity, arg_0)).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty((Object)organize2)) {
                        OrganizeEntity company3;
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize2.getShortName()) ? organize2.getShortName() : organize2.getFullName());
                        if (StringUtils.isNotEmpty((String)organize2.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company3 = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize2.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company3.getShortName()) ? company3.getShortName() : company3.getFullName());
                        }
                    }
                    if (StringUtils.isNotEmpty((String)((UserEntity)entity).getPositionId())) {
                        List<String> positionIds = Arrays.asList(((UserEntity)entity).getPositionId().split(","));
                        List<PositionEntity> positionList2 = this.positionService.getPositionList(positionIds);
                        String positionNames = positionList2.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                        vo2.setPositionName(positionNames);
                    }
                    organizeUserList.add(vo2);
                }
            }
            if ("Role".equals(type) && CollectionUtil.isNotEmpty((Collection)(roleList = (List)entry.getValue()))) {
                for (Object entity : roleList) {
                    vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(((PermissionEntityBase)entity).getId());
                    vo2.setType("Role");
                    vo2.setIcon("icon-ym icon-ym-role");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    relList = this.organizeRelationService.getRelationListByRoleId(((PermissionEntityBase)entity).getId());
                    OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                    if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                        if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                        }
                    }
                    organizeUserList.add(vo2);
                }
            }
            if ("Position".equals(type) && CollectionUtil.isNotEmpty((Collection)(positionList = (List)entry.getValue()))) {
                for (Object entity : positionList) {
                    vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(((PermissionEntityBase)entity).getId());
                    vo2.setType("Position");
                    vo2.setIcon("icon-ym icon-ym-position");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    relList = this.organizeRelationService.getRelationListByObjectIdAndType("Position", ((PermissionEntityBase)entity).getId());
                    OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                    if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                        if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                        }
                    }
                    organizeUserList.add(vo2);
                }
            }
            if (!"Group".equals(type) || !CollectionUtil.isNotEmpty((Collection)(groupList = (List)entry.getValue()))) continue;
            for (Object entity : groupList) {
                vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                vo2.setId(((GroupEntity)entity).getId());
                vo2.setType("Group");
                vo2.setIcon("icon-ym icon-ym-group");
                vo2.setHasChildren(false);
                vo2.setIsLeaf(true);
                vo2.setEnabledMark(1);
                organizeUserList.add(vo2);
            }
        }
        return organizeUserList;
    }

    @Override
    public List<UserSelectorVO> getRangeUserList(List<RangeElementModel> selected) {
        ArrayList<UserSelectorVO> listvo = new ArrayList<UserSelectorVO>();
        List<UserEntity> userData = this.getRangeElementUserList(selected);
        if (CollectionUtil.isNotEmpty(userData)) {
            List<OrganizeEntity> allOrganize = this.organizeService.getList();
            List companyList = allOrganize.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
            for (UserEntity entity : userData) {
                UserSelectorVO vo = (UserSelectorVO)JsonUtil.getJsonToBean((Object)entity, UserSelectorVO.class);
                vo.setId(entity.getId());
                vo.setParentId(entity.getOrganizeId());
                vo.setFullName(entity.getRealName());
                vo.setHeadIcon(entity.getHeadIcon());
                vo.setType("user");
                vo.setIcon("icon-ym icon-ym-tree-user2");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                OrganizeEntity organize = allOrganize.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)organize)) {
                    OrganizeEntity company;
                    vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                    if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                    }
                }
                if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                    List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                    List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                    String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                    vo.setPositionName(positionNames);
                }
                listvo.add(vo);
            }
        }
        return listvo;
    }

    @Override
    public List<UserEntity> getRangeUserList(String rangeStr) {
        if (StringUtils.isEmpty((String)rangeStr)) {
            return new ArrayList<UserEntity>();
        }
        List selected = JsonUtil.getJsonToList((String)rangeStr, RangeElementModel.class);
        return this.getRangeElementUserList(selected);
    }

    private static /* synthetic */ boolean lambda$getOrganizeUserList$16(UserEntity entity, OrganizeEntity t) {
        return t.getId().equals(entity.getOrganizeId());
    }
}

