/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.strategy;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.permission.service.strategy.ConditionModel;
import com.bringspring.system.permission.service.strategy.ConditionStrategy;
import com.bringspring.system.permission.service.strategy.FieldContentDateStrategy;
import com.bringspring.system.permission.service.strategy.FieldContentNumberStrategy;
import com.bringspring.system.permission.service.strategy.FieldContentStringStrategy;
import com.bringspring.system.permission.service.strategy.FieldContentTextStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ConditionStrategyFactory
implements InitializingBean {
    @Autowired
    private ApplicationContext applicationContext;
    private Map<Integer, ConditionStrategy> conditionStrategyMap = new HashMap<Integer, ConditionStrategy>();
    private List<FieldContentDateStrategy> fieldContentDateStrategyList = new ArrayList<FieldContentDateStrategy>();
    private List<FieldContentNumberStrategy> fieldContentNumberStrategyList = new ArrayList<FieldContentNumberStrategy>();
    private List<FieldContentStringStrategy> fieldContentStringStrategyList = new ArrayList<FieldContentStringStrategy>();
    private List<FieldContentTextStrategy> fieldContentTextStrategyList = new ArrayList<FieldContentTextStrategy>();

    public void afterPropertiesSet() throws Exception {
        Map beansOfType1 = this.applicationContext.getBeansOfType(FieldContentDateStrategy.class);
        for (Object strategy : beansOfType1.values()) {
            this.fieldContentDateStrategyList.add((FieldContentDateStrategy)strategy);
        }
        Map beansOfType2 = this.applicationContext.getBeansOfType(FieldContentNumberStrategy.class);
        for (Object strategy : beansOfType2.values()) {
            this.fieldContentNumberStrategyList.add((FieldContentNumberStrategy)strategy);
        }
        Map beansOfType3 = this.applicationContext.getBeansOfType(FieldContentStringStrategy.class);
        for (Object strategy : beansOfType3.values()) {
            this.fieldContentStringStrategyList.add((FieldContentStringStrategy)strategy);
        }
        Map beansOfType4 = this.applicationContext.getBeansOfType(FieldContentTextStrategy.class);
        for (FieldContentTextStrategy strategy : beansOfType4.values()) {
            this.fieldContentTextStrategyList.add(strategy);
        }
        Map beansOfType = this.applicationContext.getBeansOfType(ConditionStrategy.class);
        for (ConditionStrategy strategy : beansOfType.values()) {
            this.conditionStrategyMap.put(strategy.key(), strategy);
        }
    }

    public ConditionStrategy getConditionStrategy(Integer key) {
        return this.conditionStrategyMap.get(key);
    }

    public Object getFieldContentDate(String fieldContent, String symbol, String format) {
        FieldContentDateStrategy strategy = null;
        for (FieldContentDateStrategy s : this.fieldContentDateStrategyList) {
            List<Map<String, Object>> conditionOptions = s.getConditionOptions();
            for (Map<String, Object> option : conditionOptions) {
                if (!option.containsKey("value") || !String.valueOf(option.get("value")).equals(fieldContent)) continue;
                strategy = s;
                break;
            }
            if (!ObjectUtils.isNotEmpty((Object)strategy)) continue;
            break;
        }
        if (ObjectUtils.isNotEmpty(strategy)) {
            return strategy.convertFieldContent(fieldContent, symbol, format);
        }
        return null;
    }

    public Object getFieldContentNumber(String fieldContent, String symbol) {
        FieldContentNumberStrategy strategy = null;
        for (FieldContentNumberStrategy s : this.fieldContentNumberStrategyList) {
            List<Map<String, Object>> conditionOptions = s.getConditionOptions();
            for (Map<String, Object> option : conditionOptions) {
                if (!option.containsKey("value") || !String.valueOf(option.get("value")).equals(fieldContent)) continue;
                strategy = s;
                break;
            }
            if (!ObjectUtils.isNotEmpty((Object)strategy)) continue;
            break;
        }
        if (ObjectUtils.isNotEmpty(strategy)) {
            return strategy.convertFieldContent(fieldContent, symbol);
        }
        return null;
    }

    public Object getFieldContentText(String fieldContent, String symbol) {
        FieldContentTextStrategy strategy = null;
        for (FieldContentTextStrategy s : this.fieldContentTextStrategyList) {
            List<Map<String, Object>> conditionOptions = s.getConditionOptions();
            for (Map<String, Object> option : conditionOptions) {
                if (!option.containsKey("value") || !String.valueOf(option.get("value")).equals(fieldContent)) continue;
                strategy = s;
                break;
            }
            if (!ObjectUtils.isNotEmpty((Object)strategy)) continue;
            break;
        }
        if (ObjectUtils.isNotEmpty(strategy)) {
            return strategy.convertFieldContent(fieldContent, symbol);
        }
        return null;
    }

    public Object getFieldContentString(String fieldContent, String symbol) {
        FieldContentStringStrategy strategy = null;
        for (FieldContentStringStrategy s : this.fieldContentStringStrategyList) {
            List<Map<String, Object>> conditionOptions = s.getConditionOptions();
            for (Map<String, Object> option : conditionOptions) {
                if (!option.containsKey("value") || !String.valueOf(option.get("value")).equals(fieldContent)) continue;
                strategy = s;
                break;
            }
            if (!ObjectUtils.isNotEmpty((Object)strategy)) continue;
            break;
        }
        if (ObjectUtils.isNotEmpty(strategy)) {
            return strategy.convertFieldContent(fieldContent, symbol);
        }
        return null;
    }

    @Cacheable(value={"DataAuthorizeForm"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public Map<String, List<Map<String, Object>>> getDataAuthorizeForm() {
        HashMap<String, List<Map<String, Object>>> dataAuthorizeForm = new HashMap<String, List<Map<String, Object>>>();
        ArrayList numberConditionOptions = new ArrayList();
        ArrayList dateConditionOptions = new ArrayList();
        ArrayList textConditionOptions = new ArrayList();
        ArrayList stringConditionOptions = new ArrayList();
        List numberList = JsonUtil.getJsonToList(this.fieldContentNumberStrategyList, ConditionModel.class);
        numberList.stream().forEach(strategy -> {
            List<Map<String, Object>> conditionOptions = strategy.getConditionOptions();
            conditionOptions.stream().forEach(option -> {
                option.put("symbolOptions", strategy.getSymbolOptions());
                numberConditionOptions.add(option);
            });
        });
        List dateList = JsonUtil.getJsonToList(this.fieldContentDateStrategyList, ConditionModel.class);
        dateList.stream().forEach(strategy -> {
            List<Map<String, Object>> conditionOptions = strategy.getConditionOptions();
            conditionOptions.stream().forEach(option -> {
                option.put("symbolOptions", strategy.getSymbolOptions());
                dateConditionOptions.add(option);
            });
        });
        List textList = JsonUtil.getJsonToList(this.fieldContentTextStrategyList, ConditionModel.class);
        textList.stream().forEach(strategy -> {
            List<Map<String, Object>> conditionOptions = strategy.getConditionOptions();
            conditionOptions.stream().forEach(option -> {
                option.put("symbolOptions", strategy.getSymbolOptions());
                textConditionOptions.add(option);
            });
        });
        List stringList = JsonUtil.getJsonToList(this.fieldContentStringStrategyList, ConditionModel.class);
        stringList.stream().forEach(strategy -> {
            List<Map<String, Object>> conditionOptions = strategy.getConditionOptions();
            conditionOptions.stream().forEach(option -> {
                option.put("symbolOptions", strategy.getSymbolOptions());
                stringConditionOptions.add(option);
            });
        });
        stringConditionOptions.addAll(textConditionOptions);
        dataAuthorizeForm.put("numberOptions", numberConditionOptions);
        dataAuthorizeForm.put("dataTimeOptions", dateConditionOptions);
        dataAuthorizeForm.put("textOptions", textConditionOptions);
        dataAuthorizeForm.put("organizeOptions", stringConditionOptions);
        return dataAuthorizeForm;
    }
}

