package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 系统日志
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("base_system_log")
public class LogEntity {
    /**
     * 日志主键
     */
    @TableId("ID")
    private String id;

    /**
     * 用户主键
     */
    @TableField("USER_ID")
    private String userId;

    /**
     * 用户主键
     */
    @TableField("USER_NAME")
    private String userName;

    /**
     * 日志分类
     */
    @TableField("CATEGORY")
    private Integer category;

    /**
     * 日志类型
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 日志级别
     */
    @TableField("LEVEL")
    private Integer levels;

    /**
     * IP地址
     */
    @TableField("IP_ADDRESS")
    private String ipAddress;

    /**
     * IP所在城市
     */
    @TableField("IP_ADDRESS_NAME")
    private String ipAddressName;

    /**
     * 请求地址
     */
    @TableField("REQUEST_URL")
    private String requestUrl;

    /**
     * 请求方法
     */
    @TableField("REQUEST_METHOD")
    private String requestMethod;

    /**
     * 请求耗时
     */
    @TableField("REQUEST_DURATION")
    private Integer requestDuration;

    /**
     * 日志摘要
     */
    @TableField("ABSTRACTS")
    private String abstracts;

    /**
     * 日志内容
     */
    @TableField("JSON")
    private String jsons;

    /**
     * 平台设备
     */
    @TableField("PLATFORM")
    private String platForm;

    /**
     * 操作日期
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 功能主键
     */
    @TableField("MODULE_ID")
    private String moduleId;

    /**
     * 功能名称
     */
    @TableField("MODULE_NAME")
    private String moduleName;

    /**
     * 对象id
     */
    @TableField("OBJECT_ID")
    private String objectId;

}
