package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 大屏地图
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("visualdata_map")
public class VisualDataMapEntity {

    /**
     * 主键
     */
    @TableId("ID")
    private String id;

    /**
     * 名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 地图数据
     */
    @TableField("Data")
    private String data;

    /**
     * 排序
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标识
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField("CREATOR_TIME")
    private Date creatorTime;

    /**
     * 创建人
     */
    @TableField("CREATOR_USER_ID")
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField("LAST_MODIFY_TIME")
    private Date lastModifyTime;

    /**
     * 修改人
     */
    @TableField("LAST_MODIFY_USER_ID")
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除人
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}

