package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Pagination;
import com.bringspring.system.base.entity.ModuleFormEntity;

import java.util.List;

/**
 * 表单权限
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-09-14
 */
public interface ModuleFormService extends IService<ModuleFormEntity> {

    /**
     * 列表
     *
     * @return ignore
     */
    List<ModuleFormEntity> getList();

    /**
     * 列表
     *
     * @return ignore
     */
    List<ModuleFormEntity> getEnabledMarkList(String enabledMark);

    /**
     * 列表
     *
     * @param moduleId   功能主键
     * @param pagination 分页参数
     * @return ignore
     */
    List<ModuleFormEntity> getList(String moduleId, Pagination pagination);

    /**
     * 列表
     *
     * @param moduleId 功能主键
     * @return ignore
     */
    List<ModuleFormEntity> getList(String moduleId);

    /**
     * 信息
     *
     * @param id 主键值
     * @return ignore
     */
    ModuleFormEntity getInfo(String id);

    /**
     * 验证名称
     *
     * @param moduleId 功能主键
     * @param fullName 名称
     * @param id       主键值
     * @return ignore
     */
    boolean isExistByFullName(String moduleId, String fullName, String id);

    /**
     * 验证编码
     *
     * @param moduleId 功能主键
     * @param enCode   编码
     * @param id       主键值
     * @return ignore
     */
    boolean isExistByEnCode(String moduleId, String enCode, String id);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(ModuleFormEntity entity);

    /**
     * 创建
     *
     * @param entitys 实体对象
     */
    void create(List<ModuleFormEntity> entitys);

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     * @return ignore
     */
    boolean update(String id, ModuleFormEntity entity);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(ModuleFormEntity entity);
}
