package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.mapper.ModuleFormMapper;
import com.bringspring.system.base.service.ModuleFormService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 表单权限
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class ModuleFormServiceImpl extends ServiceImpl<ModuleFormMapper, ModuleFormEntity> implements ModuleFormService {

    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ModuleFormEntity> getList() {
        QueryWrapper<ModuleFormEntity> queryWrapper = new QueryWrapper<>();
        // 排序
        queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)
                .orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<ModuleFormEntity> getEnabledMarkList(String enabledMark) {
        QueryWrapper<ModuleFormEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleFormEntity::getEnabledMark,enabledMark);
        // 排序
        queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)
                .orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<ModuleFormEntity> getList(String moduleId, Pagination pagination) {
        QueryWrapper<ModuleFormEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleFormEntity::getModuleId, moduleId).orderByAsc(ModuleFormEntity::getSortCode).orderByDesc(ModuleFormEntity::getCreatorTime);
        if(!StringUtils.isEmpty(pagination.getKeyword())){
            queryWrapper.lambda().and(
                    t-> t.like(ModuleFormEntity::getEnCode,pagination.getKeyword()).or().like(ModuleFormEntity::getFullName,pagination.getKeyword())
            );
        }
        // 排序
        queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)
                .orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<ModuleFormEntity> getList(String moduleId) {
        QueryWrapper<ModuleFormEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleFormEntity::getModuleId, moduleId);
        // 排序
        queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)
                .orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public ModuleFormEntity getInfo(String id) {
        QueryWrapper<ModuleFormEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleFormEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String moduleId, String fullName, String id) {
        QueryWrapper<ModuleFormEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleFormEntity::getFullName, fullName).eq(ModuleFormEntity::getModuleId, moduleId);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(ModuleFormEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public boolean isExistByEnCode(String moduleId, String enCode, String id) {
        QueryWrapper<ModuleFormEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleFormEntity::getEnCode, enCode).eq(ModuleFormEntity::getModuleId, moduleId);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(ModuleFormEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public void create(ModuleFormEntity entity) {
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
        }
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void create(List<ModuleFormEntity> entitys) {
        Long sortCode = RandomUtil.parses();
        String userId = userProvider.get().getUserId();
        for (ModuleFormEntity entity : entitys) {
            entity.setId(RandomUtil.uuId());
            entity.setSortCode(sortCode++);
            entity.setEnabledMark("1".equals(String.valueOf(entity.getEnabledMark()))?0:1);
            entity.setCreatorUserId(userId);
            this.save(entity);
        }
    }

    @Override
    public boolean update(String id, ModuleFormEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(ModuleFormEntity entity) {
        this.removeById(entity.getId());
    }


}
