package com.bringspring.system.external.service;

import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpAgentPerm;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpDepartment;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpUser;

import java.util.List;

/**
 * 互联企业相关接口
 * WxJava的WxCpLinkedCorpService不能用，所以写一个MyWxCpLinkedCorpService。
 *
 * @since 30/1/2024 9:57 PM
 */
public interface MyWxCpLinkedCorpService {
    /**
     * 获取应用的可见范围
     *
     * @return
     * @throws WxErrorException
     */
    WxCpLinkedCorpAgentPerm getLinkedCorpAgentPerm() throws WxErrorException;

    /**
     * 获取互联企业部门列表
     *
     * @param departmentId
     * @return
     * @throws WxErrorException
     */
    List<WxCpLinkedCorpDepartment> getLinkedCorpDepartmentList(String departmentId) throws WxErrorException;

    /**
     * 获取互联企业部门成员详情
     *
     * @param departmentId
     * @return
     * @throws WxErrorException
     */
//    List<WxCpLinkedCorpUser> getLinkedCorpUserList(String departmentId) throws WxErrorException;

    /**
     * 获取互联企业部门成员详情
     *
     * @param departmentId
     * @return
     * @throws WxErrorException
     */
    List<MyWxCpLinkedCorpUser> getLinkedCorpUserList(String departmentId) throws WxErrorException;

    /**
     * 获取互联企业成员详细信息
     *
     * @param userId
     * @return
     * @throws WxErrorException
     */
//    WxCpLinkedCorpUser getLinkedCorpUser(String userId) throws WxErrorException;

    /**
     * 获取互联企业成员详细信息
     *
     * @param userId
     * @return
     * @throws WxErrorException
     */
    MyWxCpLinkedCorpUser getLinkedCorpUser(String userId) throws WxErrorException;

    /**
     * 获取互联企业部门成员
     *
     * @param departmentId
     * @return
     * @throws WxErrorException
     */
    List<WxCpLinkedCorpUser> getLinkedCorpSimpleUserList(String departmentId) throws WxErrorException;

}
