package com.bringspring.system.msgCenter.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.*;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgCenter.model.mcBusiness.McBusinessInfoVO;
import com.bringspring.system.msgCenter.model.mcMsgTemplate.*;
import com.bringspring.system.msgCenter.model.mcMsgTemplateField.McMsgTemplateFieldModel;
import com.bringspring.system.msgCenter.service.McBusinessService;
import com.bringspring.system.msgCenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgCenter.service.McMsgTemplateFieldService;
import com.bringspring.system.msgCenter.service.McMsgTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Cleanup;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.bringspring.system.msgCenter.constant.CommonConsts.ENABLED_MARK_OFF;
import static com.bringspring.system.msgCenter.constant.CommonConsts.ENABLED_MARK_ON;
import static com.bringspring.system.msgCenter.constant.DictConsts.MSG_TYPE;

/**
 * 消息模板表
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-07
 */
@Slf4j
@RestController
@Api(tags = "消息模板表", value = "mcMsgTemplate")
@RequestMapping("/api/msgCenter/mcMsgTemplate")
public class McMsgTemplateController {

    @Autowired
    private BaseDataUtil baseDataUtil;

    @Autowired
    private ConfigValueUtil configValueUtil;

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private McMsgTemplateService mcMsgTemplateService;

    @Autowired
    private McMsgTemplateFieldService mcMsgTemplateFieldService;

    @Autowired
    private McBusinessService mcBusinessService;

    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;


    /**
     * 列表
     *
     * @param mcmsgtemplatePagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody McMsgTemplatePagination mcmsgtemplatePagination) throws IOException {
        List<McMsgTemplateEntity> list = mcMsgTemplateService.getList(mcmsgtemplatePagination);
        List<McMsgTemplateListVO> listVO = JsonUtil.getJsonToList(list, McMsgTemplateListVO.class);
        //处理id字段转名称，若无需转或者为空可删除
        for (McMsgTemplateListVO vo : listVO) {
            McBusinessInfoVO business = mcBusinessService.getInfoByEnCode(vo.getMessageSource());
            vo.setMessageSource(business != null ? business.getFullName() : null);
            vo.setMessageType(baseDataUtil.getDictName(vo.getMessageType(), MSG_TYPE));
//            vo.setEnabledMark(baseDataUtil.switchSelectValue(vo.getEnabledMark(), ENABLED_MARK_ON, ENABLED_MARK_OFF));
            vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(mcmsgtemplatePagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param mcMsgTemplateCrForm
     * @return
     */
    @PostMapping
    public ActionResult create(@RequestBody @Valid McMsgTemplateCrForm mcMsgTemplateCrForm) throws DataException {
        // 校验编码是否存在重复
        if (!mcMsgTemplateService.checkEnCodeUnique(mcMsgTemplateCrForm.getEnCode(), null)) {
            return ActionResult.fail("编码已存在");
        }
        // 校验名称是否存在重复
        if (!mcMsgTemplateService.checkFullNameUnique(mcMsgTemplateCrForm.getFullName(), null)) {
            return ActionResult.fail("名称已存在");
        }
        // 校验三方变量重复
        if (!mcMsgTemplateFieldService.checkThirdFieldUnique(mcMsgTemplateCrForm.getFieldList())) {
            return ActionResult.fail("变量重复");
        }
        mcMsgTemplateService.create(mcMsgTemplateCrForm);
        return ActionResult.success("创建成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<McMsgTemplateInfoVO> info(@PathVariable("id") String id) {
        McMsgTemplateEntity entity = mcMsgTemplateService.getInfo(id);
        McMsgTemplateInfoVO vo = JsonUtil.getJsonToBean(entity, McMsgTemplateInfoVO.class);
        McBusinessInfoVO business = mcBusinessService.getInfoByEnCode(vo.getMessageSource());
        vo.setMessageSourceName(business != null ? business.getFullName() : null);
        vo.setKeywordList(business != null ? business.getKeywordList() : null);
        //子表
        List<McMsgTemplateFieldEntity> fieldList = mcMsgTemplateService.getMcMsgTemplateFieldList(id);
        for (McMsgTemplateFieldEntity fieldEntity : fieldList) {
        }
        vo.setFieldList(JsonUtil.getJsonToList(fieldList, McMsgTemplateFieldModel.class));
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<McMsgTemplateInfoVO> detailInfo(@PathVariable("id") String id) {
        McMsgTemplateEntity entity = mcMsgTemplateService.getInfo(id);
        McMsgTemplateInfoVO vo = JsonUtil.getJsonToBean(entity, McMsgTemplateInfoVO.class);

        //子表数据转换
        List<McMsgTemplateFieldEntity> fieldList = mcMsgTemplateService.getMcMsgTemplateFieldList(id);
        List<McMsgTemplateFieldModel> fieldModelList = JsonUtil.getJsonToList(fieldList, McMsgTemplateFieldModel.class);
        for (McMsgTemplateFieldModel fieldModel : fieldModelList) {
        }
        vo.setFieldList(fieldModelList);

        //附表数据转换
        McBusinessInfoVO business = mcBusinessService.getInfoByEnCode(vo.getMessageSource());
        vo.setMessageSource(business != null ? business.getFullName() : null);
        vo.setMessageType(baseDataUtil.getDictName(vo.getMessageType(), MSG_TYPE));
        vo.setEnabledMark(baseDataUtil.switchSelectValue(vo.getEnabledMark(), ENABLED_MARK_ON, ENABLED_MARK_OFF));
        vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(baseDataUtil.userSelectValue(vo.getLastModifyUserId()));

        return ActionResult.success(vo);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id,
                               @RequestBody @Valid McMsgTemplateUpForm mcMsgTemplateUpForm) throws DataException {
        // 校验编码是否存在重复
        if (!mcMsgTemplateService.checkEnCodeUnique(mcMsgTemplateUpForm.getEnCode(), id)) {
            return ActionResult.fail("编码已存在");
        }
        // 校验名称是否存在重复
        if (!mcMsgTemplateService.checkFullNameUnique(mcMsgTemplateUpForm.getFullName(), id)) {
            return ActionResult.fail("名称已存在");
        }
        // 校验三方变量重复
        if (!mcMsgTemplateFieldService.checkThirdFieldUnique(mcMsgTemplateUpForm.getFieldList())) {
            return ActionResult.fail("变量重复");
        }

        McMsgTemplateEntity entity = mcMsgTemplateService.getInfo(id);
        if (ObjectUtil.isNotNull(entity)) {
            mcMsgTemplateService.update(id, mcMsgTemplateUpForm);
            return ActionResult.success("更新成功");
        } else {
            return ActionResult.fail("更新失败，数据不存在");
        }
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        McMsgTemplateEntity entity = mcMsgTemplateService.getInfo(id);
        if (ObjectUtil.isNotNull(entity)) {
            if (mcMsgSendTemplateService.getCountByTemplateId(entity.getId()) > 0) {
                return ActionResult.fail("发送配置已关联模板，不允许删除！");
            }
            mcMsgTemplateService.delete(entity);
        }
        return ActionResult.success("删除成功");
    }

    /**
     * 消息模板下拉框
     *
     * @return
     */
    @ApiOperation("消息模板下拉框")
    @GetMapping("/Selector")
    public ActionResult<PageListVO<McMsgTemplateSelector>> selector(McMsgTemplatePagination pagination) {
        List<McMsgTemplateEntity> list = mcMsgTemplateService.getList(pagination);
        List<McMsgTemplateSelector> listSelector = JsonUtil.getJsonToList(list, McMsgTemplateSelector.class);
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        return ActionResult.page(listSelector, paginationVO);
    }

    /**
     * 模板下载
     *
     * @return
     */
    @ApiOperation("模板下载")
    @GetMapping("/templateDownload")
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("职员信息.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile("/api/Common/DownloadModel?encryption=", userInfo.getId() + "#" +
                    "职员信息.xlsx" + "#" + "Temporary"));
        } catch (Exception e) {
            log.error("信息导出Excel错误:{}", e.getMessage());
        }
        return ActionResult.success(vo);
    }

    /**
     * 导出Excel
     *
     * @return
     */
    @ApiOperation("导出Excel")
    @GetMapping("/Actions/Export")
    public ActionResult Export(McMsgTemplatePaginationExportModel mcmsgtemplatePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty(mcmsgtemplatePaginationExportModel.getSelectKey())) {
            return ActionResult.fail("请选择导出字段");
        }
        McMsgTemplatePagination mcmsgtemplatePagination = JsonUtil.getJsonToBean(mcmsgtemplatePaginationExportModel,
                McMsgTemplatePagination.class);
        List<McMsgTemplateEntity> list = mcMsgTemplateService.getTypeList(mcmsgtemplatePagination,
                mcmsgtemplatePaginationExportModel.getDataType());
        List<McMsgTemplateListVO> listVO = JsonUtil.getJsonToList(list, McMsgTemplateListVO.class);
        //处理id字段转名称，若无需转或者为空可删除
        for (McMsgTemplateListVO vo : listVO) {
            McBusinessInfoVO business = mcBusinessService.getInfoByEnCode(vo.getMessageSource());
            vo.setMessageSource(business != null ? business.getFullName() : null);
            vo.setMessageType(baseDataUtil.getDictName(vo.getMessageType(), MSG_TYPE));
            vo.setEnabledMark(baseDataUtil.switchSelectValue(vo.getEnabledMark(), ENABLED_MARK_ON, ENABLED_MARK_OFF));
            vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(baseDataUtil.userSelectValue(vo.getDeleteUserId()));
        }

        //转换为map输出
        List<Map<String, Object>> mapList = JsonUtil.getJsonToListMap(JsonUtil.getObjectToStringDateFormat(listVO,
                "yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty(mcmsgtemplatePaginationExportModel.getSelectKey()) ?
                mcmsgtemplatePaginationExportModel.getSelectKey().split(",") : new String[0];
        UserInfo userInfo = userProvider.get();
        DownloadVO vo = this.creatModelExcel(configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success(vo);
    }

    //导出表格
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        List<ExcelExportEntity> entitys = new ArrayList<>();
        if (keys.length > 0) {
            for (String key : keys) {
                switch (key) {
                    case "fullName":
                        entitys.add(new ExcelExportEntity("名称", "fullName"));
                        break;
                    case "enCode":
                        entitys.add(new ExcelExportEntity("编码", "enCode"));
                        break;
                    case "templateType":
                        entitys.add(new ExcelExportEntity("模板类型", "templateType"));
                        break;
                    case "messageSource":
                        entitys.add(new ExcelExportEntity("消息来源", "messageSource"));
                        break;
                    case "messageType":
                        entitys.add(new ExcelExportEntity("消息渠道", "messageType"));
                        break;
                    case "sortCode":
                        entitys.add(new ExcelExportEntity("排序", "sortCode"));
                        break;
                    case "enabledMark":
                        entitys.add(new ExcelExportEntity("状态", "enabledMark"));
                        break;
                    case "description":
                        entitys.add(new ExcelExportEntity("说明", "description"));
                        break;
                    case "title":
                        entitys.add(new ExcelExportEntity("标题", "title"));
                        break;
                    case "content":
                        entitys.add(new ExcelExportEntity("内容", "content"));
                        break;
                    case "templateCode":
                        entitys.add(new ExcelExportEntity("模板编号", "templateCode"));
                        break;
                    case "wxSkip":
                        entitys.add(new ExcelExportEntity("跳转方式", "wxSkip"));
                        break;
                    case "xcxAppId":
                        entitys.add(new ExcelExportEntity("关联小程序ID", "xcxAppId"));
                        break;
                    case "subscriberType":
                        entitys.add(new ExcelExportEntity("订阅类型", "subscriberType"));
                        break;
                    case "creatorTime":
                        entitys.add(new ExcelExportEntity("创建时间", "creatorTime"));
                        break;
                    case "creatorUserId":
                        entitys.add(new ExcelExportEntity("创建用户", "creatorUserId"));
                        break;
                    case "lastModifyTime":
                        entitys.add(new ExcelExportEntity("修改时间", "lastModifyTime"));
                        break;
                    case "lastModifyUserId":
                        entitys.add(new ExcelExportEntity("修改用户", "lastModifyUserId"));
                        break;
                    case "deleteTime":
                        entitys.add(new ExcelExportEntity("删除时间", "deleteTime"));
                        break;
                    case "deleteUserId":
                        entitys.add(new ExcelExportEntity("删除用户", "deleteUserId"));
                        break;
                    case "deleteMark":
                        entitys.add(new ExcelExportEntity("有效标志", "deleteMark"));
                        break;
                    default:
                        break;
                }
            }
        }

        ExportParams exportParams = new ExportParams(null, "表单信息");
        exportParams.setType(ExcelType.XSSF);
        try {
            @Cleanup Workbook workbook = new HSSFWorkbook();
            if (entitys.size() > 0) {
                workbook = ExcelExportUtil.exportExcel(exportParams, entitys, list);
            }
            String name = "表单信息" + DateUtil.dateNow("yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";

            String fileName = configValueUtil.getTemporaryFilePath() + name;
            @Cleanup FileOutputStream output = new FileOutputStream(XSSEscape.escapePath(fileName));
            workbook.write(output);
            //上传文件
            UploadUtil.uploadFile(configValueUtil.getFileType(), fileName, FileTypeEnum.TEMPORARY, name);

            vo.setName(name);
            vo.setUrl(UploaderUtil.uploaderFile(userInfo.getId() + "#" + name + "#" + "Temporary"));
        } catch (Exception e) {
            log.error("信息导出Excel错误:{}", e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }


}
