package com.bringspring.system.msgCenter.model.mcTaskMsgContent;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
public class McTaskMsgContentListVO {

    /**
     * 主键
     */
    private String id;


    /**
     * 消息di
     **/
    @JsonProperty("msgId")
    private String msgId;


    /**
     * 消息模板id
     **/
    @JsonProperty("templateId")
    private String templateId;

    /**
     * 消息模板id
     **/
    @JsonProperty("msgTemplateId")
    private String msgTemplateId;

    /**
     * 应用配置id
     **/
    @JsonProperty("msgAccountId")
    private String msgAccountId;

    /**
     * 消息渠道
     **/
    @JsonProperty("channelType")
    private String channelType;

    /**
     * 消息正文内容类型，支持 文本消息、链接消息、图文消息。
     **/
    @JsonProperty("contentType")
    private String contentType;

    /**
     * 标题
     **/
    @JsonProperty("title")
    private String title;


    /**
     * 摘要描述
     **/
    @JsonProperty("description")
    private String description;


    /**
     * 正文
     **/
    @JsonProperty("content")
    private String content;


    /**
     * 链接地址
     **/
    @JsonProperty("linkUrl")
    private String linkUrl;


    /**
     * 图片链接。
     **/
    @JsonProperty("picUrl")
    private String picUrl;


    /**
     * 创建时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("creatorTime")
    private Date creatorTime;


    /**
     * 创建人
     **/
    @JsonProperty("creatorUserId")
    private String creatorUserId;


}