package com.bringspring.system.msgCenter.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgCenter.model.mcMsgTemplate.McMsgTemplateCrForm;
import com.bringspring.system.msgCenter.model.mcMsgTemplate.McMsgTemplatePagination;
import com.bringspring.system.msgCenter.model.mcMsgTemplate.McMsgTemplateUpForm;

import java.util.List;

/**
 * 消息模板表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-07
 */
public interface McMsgTemplateService extends IService<McMsgTemplateEntity> {

    List<McMsgTemplateEntity> getList(McMsgTemplatePagination mcmsgtemplatePagination);

    List<McMsgTemplateEntity> getTypeList(McMsgTemplatePagination mcmsgtemplatePagination, String dataType);

    List<McMsgTemplateEntity> getInfoByCode(String enCode);

    McMsgTemplateEntity getInfo(String id);

    void delete(McMsgTemplateEntity entity);

    void create(McMsgTemplateCrForm mcMsgTemplateCrForm);

    boolean update(String id, McMsgTemplateUpForm mcMsgTemplateUpForm);

    //  子表方法
    List<McMsgTemplateFieldEntity> getMcMsgTemplateFieldList(String id);

    /**
     * 校验编码code的唯一
     *
     * @return 结果
     */
    boolean checkEnCodeUnique(String enCode, String id);
    /**
     * 校验名称的唯一
     *
     * @return 结果
     */
    boolean checkFullNameUnique(String fullName, String id);

    /**
     * 根据消息场景来源 统计消息模板数量
     * @param messageSource
     * @return
     */
    long getCountByMessageSource(String messageSource);
}
