package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.model.mcMsgSendTemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgCenter.model.message.MyEmailModel;
import com.bringspring.system.msgCenter.util.BlacklistUtil;
import com.bringspring.system.msgCenter.util.EmailUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bringspring.system.msgCenter.constant.CommonConsts.PART_COMMA;

/**
 * 消息中心-电子邮件下发工具类
 */
@Component
@Slf4j
public class MsgToEmailService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;


    /**
     * 发送短信
     *
     * @param isAgain        是否重发
     * @param sendTemplate   发送配置模板
     * @param taskMsgContent 业务消息内容
     * @param receiveListS    接收人source
     */
    public void sendEmail(boolean isAgain, McMsgSendTemplateModel sendTemplate,
                          McTaskMsgContentEntity taskMsgContent,
                          List<McTaskMsgReceiveEntity> receiveListS) {
        if (ObjectUtil.isEmpty(taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~·~·~·~调用了 电子邮件消息下发，但taskMsgContent为空 或 receiveList为空~·~·~·~");
        }
        List<McTaskMsgReceiveEntity> receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);

        // 消息模板
        McMsgTemplateEntity templateInfo = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());

        // 账号
        McMsgAccountEntity msgAccount = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());

        if (ObjectUtil.isNotNull(templateInfo) && ObjectUtil.isNotNull(msgAccount)) {

            // 黑名单成员
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);

            if (CollectionUtil.isNotEmpty(receiveList)) {
                // 无电子邮箱
                List<McTaskMsgReceiveEntity> emailNullList =
                        receiveList.stream().filter(r -> StringUtils.isEmpty(r.getReceiveUserId())).collect(Collectors.toList());
                // 有电子邮箱
                List<McTaskMsgReceiveEntity> emailNotNullList =
                        receiveList.stream().filter(r -> StringUtils.isNotEmpty(r.getReceiveUserId())).collect(Collectors.toList());
                List<String> emailList =
                        emailNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(emailList)) {
                    //账号配置——电子邮箱
                    Map<String, String> objModel = new HashMap<>();
                    objModel.put("emailSmtpHost", msgAccount.getSmtpServer());
                    objModel.put("emailSmtpPort", msgAccount.getSmtpPort().toString());
                    objModel.put("emailSenderName", msgAccount.getAddressorName());
                    objModel.put("emailAccount", msgAccount.getSmtpUser());
                    objModel.put("emailPassword", msgAccount.getSmtpPassword());
                    objModel.put("emailSsl", msgAccount.getSslLink().equals("1") ? "true" : "false");
                    MyEmailModel emailModel = JsonUtil.getJsonToBean(objModel, MyEmailModel.class);
                    // 设置邮件标题
                    emailModel.setEmailTitle(taskMsgContent.getTitle());
                    // 设置邮件内容
                    emailModel.setEmailContent(taskMsgContent.getContent());
                    // 获取收件人的邮箱地址
                    String toUserMail = StringUtils.join(emailList, PART_COMMA);
                    // 设置接收人员
                    emailModel.setEmailToUsers(toUserMail);

                    /**
                     * 调用API 发送消息
                     */
                    // 发送邮件
                    JSONObject retJson = EmailUtil.sendMail(emailModel);

                    /**
                     * 处理发送结果
                     */
                    if (!retJson.getBoolean("code")) {
                        log.error("发送失败");
                    } else {
                        // 写入系统的消息表、消息用户表
                    }
                    if (!retJson.getBoolean("code")) {
                        // 失败
                        String errMsg = (isAgain ? "重发失败：" : "下发失败：") + retJson.getString("error");
                        mcTaskMsgReceiveService.updateByList(isAgain, emailNotNullList, 2, errMsg);
                    } else {
                        // 成功
                        String errMsg = (isAgain ? "重发成功：" : "下发成功：") + retJson.getString("error");
                        mcTaskMsgReceiveService.updateByList(isAgain, emailNotNullList, 1, errMsg);
                    }
                }

                if (CollectionUtil.isNotEmpty(emailNullList)) {
                    String errMsg = (isAgain ? "重发失败：" : "下发失败：") + "无有效电子邮箱";
                    mcTaskMsgReceiveService.updateByList(isAgain, emailNullList, 2, errMsg);
                }
            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                // 黑名单
                mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist);
            }
        }
    }

}