package com.bringspring.system.msgCenter.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgCenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgCenter.util.WebHookUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * 消息中心-webhook下发工具类
 */
@Component
@Slf4j
public class MsgToWebhookService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;


    /**
     * 发送webhook
     *
     * @param isAgain        是否重发
     * @param taskMsgContent 业务消息内容
     * @param receiveList    业务消息接收人
     */
    public void sendWebhook(boolean isAgain, McTaskMsgContentEntity taskMsgContent,
                            List<McTaskMsgReceiveEntity> receiveList) {
        if (ObjectUtil.isEmpty(taskMsgContent) || CollectionUtil.isEmpty(receiveList)) {
            log.error("~·~·~·~调用了 webhook消息下发，但taskMsgContent为空 或 receiveList为空~·~·~·~");
        }
        for (McTaskMsgReceiveEntity receive : receiveList) {
            if (StringUtils.isNotEmpty(receive.getReceiveUserId())) {
                // 应用授权账号信息
                McMsgAccountEntity msgAccount = mcMsgAccountService.getInfo(receive.getReceiveUserId());
                if (ObjectUtil.isNotNull(msgAccount)) {
                    String approveType = String.valueOf(msgAccount.getApproveType());
                    String webhookType = String.valueOf(msgAccount.getWebhookType());
                    String webhookAddress = msgAccount.getWebhookAddress();
                    String content = taskMsgContent.getContent();
                    JSONObject retJson = new JSONObject();
                    switch (webhookType) {
                        case "1":
                            //钉钉
                            if ("1".equals(approveType)) {
                                retJson = WebHookUtil.sendDDMessage(webhookAddress, content);
                            } else if ("2".equals(approveType)) {
                                retJson = WebHookUtil.sendDingDing(webhookAddress, msgAccount.getBearer(), content);
                            }
                            break;
                        case "2":
                            if ("1".equals(approveType)) {
                                retJson = WebHookUtil.callWeChatBot(webhookAddress, content);
                            }
                            break;
                        default:
                            break;
                    }

                    /**
                     * 处理发送结果
                     */
                    if ("ok".equals(retJson.getString("errmsg"))) {
                        // 成功
                        String errMsg = (isAgain ? "重发成功：" : "下发成功：") + JSONObject.toJSONString(retJson);
                        this.settingResult(isAgain, receive, 1, errMsg);
                    } else {
                        // 失败
                        String errMsg = (isAgain ? "重发失败：" : "下发失败：") + JSONObject.toJSONString(retJson);
                        this.settingResult(isAgain, receive, 2, errMsg);
                    }
                } else {
                    // 无效的接收人
                    String errMsg = (isAgain ? "重发失败：" : "下发失败：") + "无效的接收人，未指定有效的webhook配置";
                    this.settingResult(isAgain, receive, 2, errMsg);
                }
            } else {
                // 空的接收人
                String errMsg = (isAgain ? "重发失败：" : "下发失败：") + "空的接收人，未指定webhook配置";
                this.settingResult(isAgain, receive, 2, errMsg);
            }
        }
        mcTaskMsgReceiveService.updateBatchById(receiveList);
    }

    private void settingResult(boolean isAgain, McTaskMsgReceiveEntity receive, Integer enabledMark, String remark) {
        if (!isAgain) {
            receive.setEnabledMark(enabledMark); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
            receive.setSendTime(new Date());
            receive.setSendUserId(userProvider.get().getUserId());
            receive.setDescription(remark);
            receive.setAutoAgainNum(0);
        } else {
            receive.setEnabledMark(enabledMark); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
            receive.setAgainTime(new Date());
            receive.setAgainUserId(userProvider.get().getUserId());
            receive.setDescription(remark);
            if (ObjectUtil.isEmpty(receive.getAutoAgainNum())) {
                receive.setAutoAgainNum(0);
            } else {
                receive.setAutoAgainNum(receive.getAutoAgainNum() + 1);
            }
        }
    }
}