package com.bringspring.system.msgCenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgCenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgCenter.exception.MsgCenterException;
import com.bringspring.system.msgCenter.mapper.McMsgAccountMapper;
import com.bringspring.system.msgCenter.model.mcMsgAccount.McMsgAccountCrForm;
import com.bringspring.system.msgCenter.model.mcMsgAccount.McMsgAccountPagination;
import com.bringspring.system.msgCenter.model.mcMsgAccount.McMsgAccountUpForm;
import com.bringspring.system.msgCenter.service.McMsgAccountService;
import me.chanjar.weixin.common.error.WxRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import static com.bringspring.system.msgCenter.constant.CommonConsts.NOT_UNIQUE;
import static com.bringspring.system.msgCenter.constant.CommonConsts.UNIQUE;

/**
 * 账号配置表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-03
 */
@Service
public class McMsgAccountServiceImpl extends ServiceImpl<McMsgAccountMapper, McMsgAccountEntity> implements McMsgAccountService {


    @Autowired
    private UserProvider userProvider;


    @Override
    public List<McMsgAccountEntity> getList(McMsgAccountPagination pagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcMsgAccountNum = 0;
        QueryWrapper<McMsgAccountEntity> queryWrapper = new QueryWrapper<>();
        // 分类
        if (StringUtils.isNotEmpty(pagination.getCategory())) {
            mcMsgAccountNum++;
            queryWrapper.lambda().eq(McMsgAccountEntity::getCategory, pagination.getCategory());
        }
        // 状态
        if (ObjectUtil.isNotEmpty(pagination.getEnabledMark())) {
            mcMsgAccountNum++;
            queryWrapper.lambda().eq(McMsgAccountEntity::getEnabledMark, pagination.getEnabledMark());
        }
        // 关键字查询
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            mcMsgAccountNum++;
            queryWrapper.lambda().like(McMsgAccountEntity::getFullName, pagination.getKeyword())
                    .or().like(McMsgAccountEntity::getEnCode, pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            mcMsgAccountNum++;
            queryWrapper.lambda().like(McMsgAccountEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            mcMsgAccountNum++;
            queryWrapper.lambda().like(McMsgAccountEntity::getEnCode, pagination.getEnCode());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgAccountEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgAccountEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMsgAccountEntity mcMsgAccountEntity = new McMsgAccountEntity();
                Field declaredField = mcMsgAccountEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<McMsgAccountEntity> page = new Page<>(pagination.getCurrentPage(),
                    pagination.getPageSize());
            IPage<McMsgAccountEntity> userIPage = this.page(page, queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<McMsgAccountEntity> list = new ArrayList();
            return pagination.setData(list, list.size());
        }
    }

    @Override
    public List<McMsgAccountEntity> getTypeList(McMsgAccountPagination pagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcMsgAccountNum = 0;
        QueryWrapper<McMsgAccountEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            mcMsgAccountNum++;
            queryWrapper.lambda().like(McMsgAccountEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            mcMsgAccountNum++;
            queryWrapper.lambda().like(McMsgAccountEntity::getEnCode, pagination.getEnCode());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgAccountEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgAccountEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMsgAccountEntity mcMsgAccountEntity = new McMsgAccountEntity();
                Field declaredField = mcMsgAccountEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<McMsgAccountEntity> page = new Page<>(pagination.getCurrentPage(),
                        pagination.getPageSize());
                IPage<McMsgAccountEntity> userIPage = this.page(page, queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<McMsgAccountEntity> list = new ArrayList();
                return pagination.setData(list, list.size());
            }
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public List<McMsgAccountEntity> getAccountByCategory(String category) {
        if (StringUtils.isEmpty(category)) {
            throw new MsgCenterException("账号分类不能为空！");
        }
        QueryWrapper<McMsgAccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgAccountEntity::getCategory, category);
        queryWrapper.lambda().eq(McMsgAccountEntity::getEnabledMark, 1);
        return this.list(queryWrapper);
    }

    @Override
    public McMsgAccountEntity getInfo(String id) {
        QueryWrapper<McMsgAccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgAccountEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(McMsgAccountCrForm mcMsgAccountCrForm) {
        McMsgAccountEntity entity = JsonUtil.getJsonToBean(mcMsgAccountCrForm, McMsgAccountEntity.class);
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        this.save(entity);
    }

    @Override
    public boolean update(String id, McMsgAccountUpForm mcMsgAccountUpForm) {
        McMsgAccountEntity entity = JsonUtil.getJsonToBean(mcMsgAccountUpForm, McMsgAccountEntity.class);
        entity.setId(id);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        return this.updateById(entity);
    }

    @Override
    public void delete(McMsgAccountEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }

    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper<McMsgAccountEntity> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(McMsgAccountEntity::getDeleteMark, DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.eq(McMsgAccountEntity::getEnCode, enCode);
        queryWrapper.last("limit 1");
        McMsgAccountEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return NOT_UNIQUE;
        }
        return UNIQUE;
    }

    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper<McMsgAccountEntity> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(McMsgAccountEntity::getDeleteMark, DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.eq(McMsgAccountEntity::getFullName, fullName);
        queryWrapper.last("limit 1");
        McMsgAccountEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return NOT_UNIQUE;
        }
        return UNIQUE;
    }
}