/*
消息中心表结构 初始化
 Date: 15/07/2024 10:38:12
*/

-- ----------------------------
-- Table structure for mc_business
-- ----------------------------
DROP TABLE IF EXISTS `mc_business`;
CREATE TABLE `mc_business`
(
    `id`                  varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
    `category`            varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类 textmsg文本消息, linkmsg链接消息, imgtextmsg:图文消息',
    `full_name`           varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
    `en_code`             varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
    `sort_code`           bigint(19) NULL DEFAULT NULL COMMENT '排序码',
    `enabled_mark`        int(10) NULL DEFAULT NULL COMMENT '状态（禁用 启用）',
    `description`         varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
    `creator_time`        datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id`     varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
    `last_modify_time`    datetime NULL DEFAULT NULL COMMENT '修改时间',
    `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
    `delete_time`         datetime NULL DEFAULT NULL COMMENT '删除时间',
    `delete_user_id`      varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除用户',
    `delete_mark`         int(10) NULL DEFAULT NULL COMMENT '有效标志',
    `company_id`          varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息业务场景信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_business_keyword
-- ----------------------------
DROP TABLE IF EXISTS `mc_business_keyword`;
CREATE TABLE `mc_business_keyword`
(
    `id`              varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
    `business_code`   varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息业务场景code',
    `full_name`       varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
    `en_code`         varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
    `example`         varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '示例',
    `closable`        varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否允许关闭',
    `creator_time`    datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息业务场景关键字信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_msg_account
-- ----------------------------
DROP TABLE IF EXISTS `mc_msg_account`;
CREATE TABLE `mc_msg_account`
(
    `id`                  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
    `category`            varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类,1站内信 2电子邮箱 3短信 4阿里钉钉 5企业微信 6微信小程序 7微信公众号',
    `full_name`           varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
    `en_code`             varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
    `addressor_name`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发件人昵称',
    `smtp_server`         varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SMTP服务器	',
    `smtp_port`           int(11) NULL DEFAULT NULL COMMENT 'SMTP端口',
    `ssl_link`            int(11) NULL DEFAULT NULL COMMENT 'SSL安全链接，0关 1开',
    `smtp_user`           varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SMTP用户名',
    `smtp_password`       varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SMTP密码	',
    `channel`             int(11) NULL DEFAULT NULL COMMENT '渠道 1阿里云，2腾讯云',
    `sms_signature`       varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '短信签名',
    `app_id`              varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '应用ID',
    `app_secret`          varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '应用Secret',
    `end_point`           varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'EndPoint（阿里云）',
    `sdk_app_id`          varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'SDK AppID（腾讯云）',
    `app_key`             varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'AppKey（腾讯云）',
    `zone_name`           varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地域域名（腾讯云）',
    `zone_param`          varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地域参数（腾讯云）',
    `enterprise_id`       varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '企业id',
    `agent_id`            varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'AgentID',
    `webhook_type`        int(11) NULL DEFAULT NULL COMMENT 'WebHook类型，1钉钉，2企业微信',
    `webhook_address`     varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'WebHook地址	',
    `approve_type`        int(11) NULL DEFAULT NULL COMMENT '认证类型，1无需认证，2bearer令牌',
    `bearer`              varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'Bearer令牌（密钥）,approve_type为2时必填',
    `program_state`       varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '程序类型：developer为开发版；trial为体验版；formal为正式版；默认为正式版',
    `user_name`           varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户名（基本认证）',
    `password`            varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '密码（基本认证）',
    `sort_code`           bigint(20) NULL DEFAULT NULL COMMENT '排序码',
    `description`         varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
    `enabled_mark`        int(11) NULL DEFAULT NULL COMMENT '有效标志, 0禁用 1启用',
    `creator_time`        datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id`     varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建用户',
    `last_modify_time`    datetime NULL DEFAULT NULL COMMENT '修改时间',
    `last_modify_user_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改用户',
    `delete_time`         datetime NULL DEFAULT NULL COMMENT '删除时间',
    `delete_user_id`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除用户',
    `delete_mark`         int(11) NULL DEFAULT NULL COMMENT '有效标志',
    `company_id`          varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属公司',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '账号配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_msg_send
-- ----------------------------
DROP TABLE IF EXISTS `mc_msg_send`;
CREATE TABLE `mc_msg_send`
(
    `id`                  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
    `full_name`           varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
    `en_code`             varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
    `template_type`       varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板类型，0自定义模板 1系统模板.',
    `message_source`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息场景来源(mc_business表encode).',
    `description`         varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述或说明',
    `enabled_mark`        int(50) NULL DEFAULT NULL COMMENT '状态 0禁用 1启用.',
    `sort_code`           bigint(50) NULL DEFAULT NULL COMMENT '排序码',
    `creator_time`        datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id`     varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建用户',
    `last_modify_time`    datetime NULL DEFAULT NULL COMMENT '修改时间',
    `last_modify_user_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改用户',
    `delete_time`         datetime NULL DEFAULT NULL COMMENT '删除时间',
    `delete_user_id`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除用户',
    `delete_mark`         int(50) NULL DEFAULT NULL COMMENT '有效标志',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '消息发送配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_msg_send_template
-- ----------------------------
DROP TABLE IF EXISTS `mc_msg_send_template`;
CREATE TABLE `mc_msg_send_template`
(
    `id`                  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
    `send_config_id`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息发送配置id',
    `message_type`        varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息渠道类型 1站内信 2电子邮箱 3短信 4阿里钉钉 5企业微信 6微信小程序 7微信公众号.',
    `template_id`         varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息模板id(mc_msg_template表主键id).',
    `account_config_id`   varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '账号配置idmc_msg_account表主键id).',
    `description`         varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
    `enabled_mark`        int(50) NULL DEFAULT NULL COMMENT '状态 0禁用 1启用.',
    `sort_code`           bigint(50) NULL DEFAULT NULL COMMENT '排序码',
    `creator_time`        datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id`     varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建用户',
    `last_modify_time`    datetime NULL DEFAULT NULL COMMENT '修改时间',
    `last_modify_user_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改用户',
    `delete_time`         datetime NULL DEFAULT NULL COMMENT '删除时间',
    `delete_user_id`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除用户',
    `delete_mark`         int(50) NULL DEFAULT NULL COMMENT '有效标志',
    `company_id`          varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属公司',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '发送配置模板表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_msg_template
-- ----------------------------
DROP TABLE IF EXISTS `mc_msg_template`;
CREATE TABLE `mc_msg_template`
(
    `id`                  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
    `full_name`           varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
    `en_code`             varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
    `template_type`       varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板类型，0自定义模板 1系统模板.',
    `message_source`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息场景来源(mc_business表encode).',
    `message_type`        varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息渠道类型 1站内信 2电子邮箱 3短信 4阿里钉钉 5企业微信 6微信小程序 7微信公众号.',
    `description`         varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述或说明.',
    `title`               varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息标题.(message_type:1|2|4|5) ',
    `content`             text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '消息内容.(message_type:2|4|5)',
    `template_code`       varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方模板编号.(message_type:3|6|7)',
    `wx_skip`             varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '跳转方式，1小程序,2页面.(message_type:7)',
    `xcx_app_id`          varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '小程序id.(message_type:6|7)',
    `subscriber_type`     varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板订阅类型，1一次性订阅;2长期订阅.(message_type:6)',
    `enabled_mark`        int(11) NULL DEFAULT NULL COMMENT '状态 0禁用 1启用.',
    `sort_code`           bigint(20) NULL DEFAULT NULL COMMENT '排序码',
    `creator_time`        datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id`     varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建用户',
    `last_modify_time`    datetime NULL DEFAULT NULL COMMENT '修改时间',
    `last_modify_user_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改用户',
    `delete_time`         datetime NULL DEFAULT NULL COMMENT '删除时间',
    `delete_user_id`      varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除用户',
    `delete_mark`         int(11) NULL DEFAULT NULL COMMENT '有效标志 0未删除 1已删除',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '消息模板表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_msg_template_field
-- ----------------------------
DROP TABLE IF EXISTS `mc_msg_template_field`;
CREATE TABLE `mc_msg_template_field`
(
    `id`              varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
    `template_id`     varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息模板id',
    `third_field`     varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板关键词变量',
    `keyword_code`    varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '场景来源参数',
    `is_title`        int(11) NULL DEFAULT NULL COMMENT '是否标题',
    `creator_time`    datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建用户',
    `sort_code`       bigint(20) NULL DEFAULT NULL COMMENT '排序码',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '消息模板变量表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_task_msg
-- ----------------------------
DROP TABLE IF EXISTS `mc_task_msg`;
CREATE TABLE `mc_task_msg`
(
    `id`                  varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键id',
    `task_code`           varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务系统的code.必填.',
    `send_code`           varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送配置code.必填.(mc_msg_send表encode)',
    `business_key`        longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '消息场景关键词，key和value均为字符串格式。示例{\"title\":\"中奖通知\",\"description\":\"恭喜你抽中华为P70一台\",\"content\":\"恭喜你抽中华为P70一台,请联系行政同事领取。\",\"url\":\"\"}，必填。',
    `to_user_ids`         longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '接收者的用户列表，base_user表主键以“,”分割，示例值\"123,456\"。最大列表长度为1000。不必填。@ALL标识全部发送 此时to_dept_ids不生效。',
    `to_dept_ids`         longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '接收者的部门id列表，base_organize表主键以“,”分割，示例值\"123,456\"。最大列表长度为100。不必填，to_dept_ids和to_user_ids不能同时为空。',
    `custom_key`          longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '自定义参数。示例{\"route\":\"路由跳转标记\",\"task_id\":\"流程业务id\"...}，非必填。',
    `enabled_mark`        int(11) NULL DEFAULT NULL COMMENT '状态，1待发送、2已发送',
    `description`         varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
    `creator_time`        datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id`     varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
    `last_modify_time`    datetime NULL DEFAULT NULL COMMENT '修改时间',
    `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务场景消息表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_task_msg_content
-- ----------------------------
DROP TABLE IF EXISTS `mc_task_msg_content`;
CREATE TABLE `mc_task_msg_content`
(
    `id`              varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键id',
    `msg_id`          varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息di.(mc_task_msg表主键id)',
    `template_id`     varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息模板id.(mc_msg_send_template表主键id)',
    `channel_type`    varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息发送渠道类型，站内、企业微信、邮箱、短信、钉钉',
    `content_type`    varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分类 textmsg文本消息, linkmsg链接消息, imgtextmsg:图文消息',
    `title`           varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标题，已经填充了模板中的占位符。不超过128个字节，超过会自动截断',
    `description`     varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '摘要描述，通知栏上方描述（摘要）。不超过512个字节，超过会自动截断',
    `content`         text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '正文，已经填充了模板中的占位符/三方模板关键词。',
    `link_url`        varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '链接消息的链接地址。拼接msgId',
    `pic_url`         varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图文消息的图片链接。',
    `creator_time`    datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务场景消息内容表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for mc_task_msg_receive
-- ----------------------------
DROP TABLE IF EXISTS `mc_task_msg_receive`;
CREATE TABLE `mc_task_msg_receive`
(
    `id`              varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键id',
    `msg_id`          varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息id.(mc_task_msg表主键id)',
    `template_id`     varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息模板id.(mc_msg_send_template表主键id)',
    `content_id`      varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息内容id.(mc_task_msg_content表主键id)',
    `channel_type`    varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息发送渠道类型，站内、企业微信、邮箱、短信、钉钉',
    `sys_user_id`     varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息接收人系统用户表id，冗余字段 方便使用系统用户接收人检索',
    `receive_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息接收人唯一标识，站内:base_user、企业微信：qyhUserId、邮箱:123@qq.com、短信:155XXXXXXXX、钉钉:ddUserid',
    `enabled_mark`    int(11) NULL DEFAULT NULL COMMENT '状态，0待下发、1下发成功、2下发失败',
    `send_time`       datetime NULL DEFAULT NULL COMMENT '发送时间',
    `send_user_id`    varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送人',
    `again_time`      datetime NULL DEFAULT NULL COMMENT '重发时间',
    `again_user_id`   varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重发人',
    `is_read`         int(11) NULL DEFAULT NULL COMMENT '是否阅读，0否、1是',
    `read_time`       datetime NULL DEFAULT NULL COMMENT '阅读时间',
    `read_count`      int(11) NULL DEFAULT NULL COMMENT '阅读次数',
    `description`     varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
    `creator_time`    datetime NULL DEFAULT NULL COMMENT '创建时间',
    `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
    `delete_time`     datetime NULL DEFAULT NULL COMMENT '删除时间',
    `delete_user_id`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除用户',
    `delete_mark`     int(2) NULL DEFAULT 0 COMMENT '有效标志 0有效 1无效',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务场景消息接收记录表' ROW_FORMAT = DYNAMIC;

/*
 Date: 23/07/2024
*/
-- 增加字段
ALTER TABLE `mc_task_msg`
    ADD COLUMN `to_type` varchar(2) NULL COMMENT '接收者类型(1:指定成员、2:部门成员、3:全部成员)' AFTER `business_key`;

-- 增加字段
ALTER TABLE `mc_msg_account`
    ADD COLUMN `address` varchar(255) NULL COMMENT '网址' AFTER `password`;

/*
 Date: 2024-08-01
-- 增加字段
*/
ALTER TABLE `mc_task_msg_receive`
    ADD COLUMN `msg_template_id` varchar(50) NULL COMMENT '消息模板id(mc_msg_template表主键id).' AFTER `template_id`,
    ADD COLUMN `msg_account_id` varchar(50) NULL COMMENT '账号配置idmc_msg_account表主键id).' AFTER `msg_template_id`;

ALTER TABLE `mc_task_msg_content`
    ADD COLUMN `msg_template_id` varchar(50) NULL COMMENT '消息模板id(mc_msg_template表主键id).' AFTER `template_id`,
    ADD COLUMN `msg_account_id` varchar(50) NULL COMMENT '账号配置idmc_msg_account表主键id).' AFTER `msg_template_id`;

-- 发送配置增加 业务系统的code
ALTER TABLE `mc_msg_send`
    ADD COLUMN `task_code` varchar(255) NULL COMMENT '业务系统的code.' AFTER `en_code`;

/*
 Date: 11/09/2024
*/
-- 增加字段
ALTER TABLE `mc_task_msg`
    ADD COLUMN `auto_again_max_num` int(11) NULL DEFAULT 0 COMMENT '渠道消息未成功发出，自动重发最大次数' AFTER `custom_key`;
ALTER TABLE `mc_task_msg_receive`
    ADD COLUMN `auto_again_num` int(11) NULL DEFAULT 0 COMMENT '渠道消息未发出，自动重发次数' AFTER `again_user_id`;
ALTER TABLE `mc_task_msg_receive`
    ADD COLUMN `auto_again_max_num` int(11) NULL DEFAULT 0 COMMENT '渠道消息未发出，自动重发最大限制次数' AFTER `auto_again_num`;
