package com.bringspring.system.msgCenter.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.msgCenter.model.*;
import com.bringspring.system.msgCenter.model.mcTaskMsg.McTaskMsgCrForm;
import com.bringspring.system.msgCenter.service.McTaskMsgService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import static com.bringspring.system.msgCenter.constant.CommonConsts.AUTO_AGAIN_MAX_NUM;


/**
 * 消息中心-业务消息发送工具类
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/22 9:06
 */
@Component
@Slf4j
public class SendTaskMsgUtils {

    @Autowired
    private McTaskMsgService mcTaskMsgService;

    /**
     * 创建并发送业务消息
     *
     * @param taskMsg
     */
    public void sendTaskMsg(TaskMsg taskMsg) throws Exception {
        McTaskMsgCrForm mcTaskMsgCrForm = new McTaskMsgCrForm();
        mcTaskMsgCrForm.setTaskCode(taskMsg.getTaskCode());
        mcTaskMsgCrForm.setSendCode(taskMsg.getSendCode());
        mcTaskMsgCrForm.setToUserIds(taskMsg.getToUserIds());
        mcTaskMsgCrForm.setToDeptIds(taskMsg.getToDeptIds());
        mcTaskMsgCrForm.setDescription(taskMsg.getDescription());
        mcTaskMsgCrForm.setAutoAgainMaxNum(ObjectUtil.isEmpty(taskMsg.getAutoAgainMaxNum()) ? AUTO_AGAIN_MAX_NUM :
                taskMsg.getAutoAgainMaxNum());
        BusinessKeys businessKey = taskMsg.getBusinessKey();
        if (ObjectUtil.isNotNull(businessKey)) {
            Map<String, String> keys = businessKey.getKeys();
            if (ObjectUtil.isNull(keys)) keys = new HashMap<>();
            Field[] fieldsDirectly = ReflectUtil.getFieldsDirectly(businessKey.getClass(), false);
            for (int i = 0; i < fieldsDirectly.length; i++) {
                String key = fieldsDirectly[i].getName();
                Object val = ReflectUtil.getFieldValue(businessKey, key);
                if (ObjectUtil.isNull(val)) {
                    keys.put(key, null);
                } else {
                    keys.put(key, val.toString());
                }
            }
            mcTaskMsgCrForm.setBusinessKey(JsonUtil.getObjectToString(keys));
        }
        CustomKeysLink customKey = taskMsg.getCustomKey();
        if (ObjectUtil.isNotNull(customKey)) {
            mcTaskMsgCrForm.setCustomKey(JsonUtil.getObjectToString(customKey));
        }

        // 创建业务消息并下发
        mcTaskMsgService.addAndSendMessage(mcTaskMsgCrForm);
    }

}
