package com.bringspring.system.permission.aop;

import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 17:12
 */
@Slf4j
@Aspect
@Component
@Order(1)
public class DataSourceBindAspect {

    @Autowired
    UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Pointcut("((execution(* com.bringspring.*.controller.*.*(..))) " +
            "&& !execution(* com.bringspring.oauth.controller.LoginController.Login(..)))" +
            "|| execution(* com.bringspring.system.message.websocket.WebSocket.*(..))")
    public void bindDataSource() {

    }

    /**
     * NoDataSourceBind 不需要绑定数据库的注解
     *
     * @param pjp
     * @return
     * @throws Throwable
     */
    @Around("bindDataSource() && !@annotation(com.bringspring.common.base.NoDataSourceBind)")
    public Object doAroundService(ProceedingJoinPoint pjp) throws Throwable {
        if (Boolean.parseBoolean(configValueUtil.getMultiTenancy())) {
            if ("true".equals(DataSourceContextHolder.getDatasourceName())) {
                return pjp.proceed();
            }
            UserInfo userInfo = userProvider.get();
            if (StringUtils.isNotEmpty(userInfo.getTenantDbConnectionString())) {
                DataSourceContextHolder.setDatasource(userInfo.getTenantId(), userInfo.getTenantDbConnectionString());
                Object obj = pjp.proceed();
                return obj;
            }
            log.error("租户" + userInfo.getTenantId() + "数据库不存在");
            return null;
        }
        Object obj = pjp.proceed();
        return obj;
    }
}
