package com.bringspring.system.permission.constant;

import java.util.HashMap;
import java.util.Map;

public enum UserEnableMarkEnum {
    ENABLE("正常",1),
    DISABLED("禁用",0),
    LOCKED("锁定",2);

    private String desc;

    private Integer code;

    UserEnableMarkEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static Map<Integer, UserEnableMarkEnum> getAllToMap() {
        Map<Integer, UserEnableMarkEnum> map = new HashMap<>();
        for (UserEnableMarkEnum alarmType : values()) {
            map.put(alarmType.getCode(), alarmType);
        }
        return map;
    }
}
