package com.bringspring.system.permission.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.*;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.SumTree;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.permission.entity.BasePositionRelationEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.model.basepositionrelation.*;
import com.bringspring.system.permission.model.organize.OrganizeDepartSelectorListVO;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.BasePositionRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.system.permission.util.PermissionUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Cleanup;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 岗位关系
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-04-16
 */
@Slf4j
@RestController
@Api(tags = "岗位关系 ", value = "PositionRelation")
@RequestMapping("/api/permission/PositionRelation")
public class PositionRelationController {

    @Autowired
    private BaseDataUtil baseDataUtil;

    @Autowired
    private ConfigValueUtil configValueUtil;

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private BasePositionRelationService basePositionRelationService;

    @Autowired
    private RoleService roleService;

    @Autowired
    private PositionService positionService;

    @Autowired
    private OrganizeService organizeService;

    /**
     * 列表
     *
     * @param basePositionRelationPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody BasePositionRelationPagination basePositionRelationPagination) throws IOException {

        List<OrganizeEntity> listOrg =
                organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());

        List<BasePositionRelationEntity> list = basePositionRelationService.getList(basePositionRelationPagination);
        //处理id字段转名称，若无需转或者为空可删除

        List<BasePositionRelationListVO> listVO = JsonUtil.getJsonToList(list, BasePositionRelationListVO.class);
        for (BasePositionRelationListVO basePositionRelationVO : listVO) {
            if ("Role".equals(basePositionRelationVO.getObjectType())) {
                RoleEntity infoRole = roleService.getInfo(basePositionRelationVO.getObjectId());
                if (!ObjectUtil.isEmpty(infoRole)) {
                    basePositionRelationVO.setObjectIdName(infoRole.getFullName());
                    basePositionRelationVO.setEnCode(infoRole.getEnCode());
                    basePositionRelationVO.setRoleType(infoRole.getType());
                    basePositionRelationVO.setOrganizeInfo(infoRole.getEnCode());
                }
            }

            PositionEntity infoPosition = positionService.getInfo(basePositionRelationVO.getPositionId());
            if (!ObjectUtil.isEmpty(infoPosition)) {
                //  部门信息
                OrganizeEntity entity =
                        listOrg.stream().filter(t -> t.getId().equals(infoPosition.getOrganizeId())).findFirst().orElse(new OrganizeEntity());
                if (infoPosition.getOrganizeId().equals(entity.getId())) {
                    basePositionRelationVO.setOrganizeInfo(entity.getFullName());
                }
                basePositionRelationVO.setOrganizeInfo(PermissionUtil.getLinkInfoByOrgId(infoPosition.getOrganizeId()
                        , organizeService, false));
                basePositionRelationVO.setPositionName(infoPosition.getFullName());
            }
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(basePositionRelationPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param
     * @return
     */
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid BasePositionRelationUpForm basePositionRelationUpForm) throws DataException {
        String mainId = RandomUtil.uuId();
        if (!ObjectUtil.isEmpty(basePositionRelationUpForm.getObjectIdList())) {
            List<String> objectIdList = basePositionRelationUpForm.getObjectIdList();
            for (int i = 0; i < objectIdList.size(); i++) {
                String v = objectIdList.get(i);
                BasePositionRelationEntity entitySave = new BasePositionRelationEntity();
                entitySave.setId(RandomUtil.uuId());
                entitySave.setPositionId(basePositionRelationUpForm.getPositionId());
                entitySave.setObjectType(basePositionRelationUpForm.getObjectType());
                entitySave.setObjectId(v);
                entitySave.setSortCode(Long.valueOf(i + 1));
                basePositionRelationService.save(entitySave);
            }
        }
        return ActionResult.success("创建成功");
    }

    /**
     * 员工管理处获取部门下拉框列表，添加数据权限设置,只显示当前登录用户所在组织
     *
     * @return
     */
    @ApiOperation("获取部门下拉框列表")
    @GetMapping("/UserDepartPosi/Selector/{menuId}")
    public ActionResult<ListVO<OrganizeDepartSelectorListVO>> getListUserDepartment(@PathVariable("menuId") String menuId) {
//        查询数据权限数据
//        List<OrganizeEntity> organizeByDataAuthorize = organizeService.getOrganizeByDataPermission(new
//        OrganizePagination(menuId));

        //查询数据权限数据  添加父节点 直属组织
        List<OrganizeEntity> list = organizeService.getOrganizeListDataPermission(menuId);

        //        重点models
        List<OrganizeModel> models = JsonUtil.getJsonToList(list, OrganizeModel.class);

        List<PositionEntity> listPosition = positionService.getList();

        List<OrganizeModel> modelsPosition = new ArrayList<>();

        for (OrganizeModel model : models) {
            if ("department".equals(model.getType())) {
                model.setIcon("icon-ym icon-ym-tree-department1");
            } else if ("company".equals(model.getType())) {
                model.setIcon("icon-ym icon-ym-tree-organization3");
            }
        }
        listPosition.stream().forEach(v -> {
            OrganizeModel organizeModel = JsonUtil.getJsonToBean(v, OrganizeModel.class);
            organizeModel.setParentId(v.getOrganizeId());
            organizeModel.setType("position");
            modelsPosition.add(organizeModel);
        });
        models.addAll(modelsPosition);
        List<SumTree<OrganizeModel>> trees = TreeDotUtils.convertListToTreeDotFilter(models);
        List<OrganizeDepartSelectorListVO> listVO = JsonUtil.getJsonToList(trees, OrganizeDepartSelectorListVO.class);
        if (!CollectionUtil.isEmpty(listVO)) {
//            公司从小到大排序
            Collections.sort(listVO.get(0).getChildren());
            // 部门从小到大排序
            if (!CollectionUtil.isEmpty(listVO.get(0).getChildren().get(0).getChildren())) {
                Collections.sort(listVO.get(0).getChildren().get(0).getChildren());
            }
        }
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success(vo);
    }


    /**
     * 模板下载
     *
     * @return
     */
    @ApiOperation("模板下载")
    @GetMapping("/templateDownload")
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("职员信息.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile("/api/Common/DownloadModel?encryption=", userInfo.getId() + "#" +
                    "职员信息.xlsx" + "#" + "Temporary"));
        } catch (Exception e) {
            log.error("信息导出Excel错误:{}", e.getMessage());
        }
        return ActionResult.success(vo);
    }

    /**
     * 导出Excel
     *
     * @return
     */
    @ApiOperation("导出Excel")
    @GetMapping("/Actions/Export")
    public ActionResult Export(BasePositionRelationPaginationExportModel basePositionRelationPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty(basePositionRelationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail("请选择导出字段");
        }
        BasePositionRelationPagination basePositionRelationPagination =
                JsonUtil.getJsonToBean(basePositionRelationPaginationExportModel, BasePositionRelationPagination.class);
        List<BasePositionRelationEntity> list =
                basePositionRelationService.getTypeList(basePositionRelationPagination,
                        basePositionRelationPaginationExportModel.getDataType());
        //处理id字段转名称，若无需转或者为空可删除
        for (BasePositionRelationEntity entity : list) {
        }
        List<BasePositionRelationListVO> listVO = JsonUtil.getJsonToList(list, BasePositionRelationListVO.class);
        for (BasePositionRelationListVO basePositionRelationVO : listVO) {
        }

        //转换为map输出
        List<Map<String, Object>> mapList = JsonUtil.getJsonToListMap(JsonUtil.getObjectToStringDateFormat(listVO,
                "yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty(basePositionRelationPaginationExportModel.getSelectKey()) ?
                basePositionRelationPaginationExportModel.getSelectKey().split(",") : new String[0];
        UserInfo userInfo = userProvider.get();
        DownloadVO vo = this.creatModelExcel(configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success(vo);
    }

    //导出表格
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        List<ExcelExportEntity> entitys = new ArrayList<>();
        if (keys.length > 0) {
            for (String key : keys) {
                switch (key) {
                    case "positionId":
                        entitys.add(new ExcelExportEntity("角色主键", "positionId"));
                        break;
                    case "objectType":
                        entitys.add(new ExcelExportEntity("对象类型（角色：Role）", "objectType"));
                        break;
                    case "objectId":
                        entitys.add(new ExcelExportEntity("对象主键", "objectId"));
                        break;
                    default:
                        break;
                }
            }
        }

        ExportParams exportParams = new ExportParams(null, "表单信息");
        exportParams.setType(ExcelType.XSSF);
        try {
            @Cleanup Workbook workbook = new HSSFWorkbook();
            if (entitys.size() > 0) {
                workbook = ExcelExportUtil.exportExcel(exportParams, entitys, list);
            }
            String name = "表单信息" + DateUtil.dateNow("yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";

            String fileName = configValueUtil.getTemporaryFilePath() + name;
            @Cleanup FileOutputStream output = new FileOutputStream(XSSEscape.escapePath(fileName));
            workbook.write(output);
            //上传文件
            UploadUtil.uploadFile(configValueUtil.getFileType(), fileName, FileTypeEnum.TEMPORARY, name);

            vo.setName(name);
            vo.setUrl(UploaderUtil.uploaderFile(userInfo.getId() + "#" + name + "#" + "Temporary"));
        } catch (Exception e) {
            log.error("信息导出Excel错误:{}", e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/batchRemove/{ids}")
    @Transactional
    public ActionResult batchRemove(@PathVariable("ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            i++;
        }
        if (i == 0) {
            return ActionResult.fail("删除失败");
        }
        return ActionResult.success("删除成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<BasePositionRelationInfoVO> info(@PathVariable("id") String id) {
        BasePositionRelationEntity entity = basePositionRelationService.getInfo(id);
        BasePositionRelationInfoVO vo = JsonUtil.getJsonToBean(entity, BasePositionRelationInfoVO.class);
        return ActionResult.success(vo);
    }

    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/infoByPosition/{id}")
    public ActionResult<BasePositionRelationInfoVO> infoByPosition(@PathVariable("id") String id) {
        List<BasePositionRelationEntity> entity = basePositionRelationService.infoByPosition(id);
        List<String> objectIdList = new ArrayList<>();
        BasePositionRelationInfoVO vo = new BasePositionRelationInfoVO();
        entity.stream().forEach(v -> {
            objectIdList.add(v.getObjectId());
        });
        vo.setId(id);
        vo.setPositionId(id);
        vo.setObjectIdList(objectIdList);
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<BasePositionRelationInfoVO> detailInfo(@PathVariable("id") String id) {
        BasePositionRelationEntity entity = basePositionRelationService.getInfo(id);
        BasePositionRelationInfoVO vo = JsonUtil.getJsonToBean(entity, BasePositionRelationInfoVO.class);
        return ActionResult.success(vo);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    @Transactional
    public ActionResult update(@PathVariable("id") String id,
                               @RequestBody @Valid BasePositionRelationUpForm basePositionRelationUpForm) throws DataException {
        UserInfo userInfo = userProvider.get();
        List<BasePositionRelationEntity> entity = basePositionRelationService.infoByPosition(id);
        if (entity != null) {
            // 老的删掉，新的新增
            basePositionRelationService.deleteByPosition(basePositionRelationUpForm);
            if (!ObjectUtil.isEmpty(basePositionRelationUpForm.getObjectIdList())) {
                List<String> objectIdList = basePositionRelationUpForm.getObjectIdList();
                for (int i = 0; i < objectIdList.size(); i++) {
                    String v = objectIdList.get(i);
                    BasePositionRelationEntity entitySave = new BasePositionRelationEntity();
                    entitySave.setId(RandomUtil.uuId());
                    entitySave.setPositionId(basePositionRelationUpForm.getPositionId());
                    entitySave.setObjectType(basePositionRelationUpForm.getObjectType());
                    entitySave.setObjectId(v);
                    entitySave.setSortCode(Long.valueOf(i + 1));
                    basePositionRelationService.save(entitySave);
                }
            }
            return ActionResult.success("更新成功");
        } else {
            return ActionResult.fail("更新失败，数据不存在");
        }
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @Transactional
    public ActionResult delete(@PathVariable("id") String id) {
        BasePositionRelationEntity entity = basePositionRelationService.getInfo(id);
        if (entity != null) {
            basePositionRelationService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }


}
