package com.bringspring.system.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;

import java.util.List;

/**
 * <p>
 * 组织关系 服务类
 * </p>
 *
 * @author YanYu
 * @since 2022-01-19
 */
public interface OrganizeRelationService extends IService<OrganizeRelationEntity> {

    /**
     * 获取组织关联对象
     *
     * @param organizeIds 组织id集合
     */
    List<OrganizeRelationEntity> getRelationListByOrganizeId(List<String> organizeIds);

    /**
     * 获取组织角色关联对象
     *
     * @param roleId 角色ID
     * @return 关联对象集合
     */
    List<OrganizeRelationEntity> getRelationListByRoleId(String roleId);

    /**
     * 获取组织角色关联对象
     *
     * @param roleId 角色ID
     * @return 关联对象集合
     */
    List<OrganizeRelationEntity> getRelationListByRoleIdList(List<String> roleId);

    /**
     * 通过对象id获取组织关系
     *
     * @param objectType 关系
     * @param objectId   对象id
     * @return 关联对象集合
     */
    List<OrganizeRelationEntity> getRelationListByObjectIdAndType(String objectType, String objectId);


    /**
     * 判断组织下关联对象类型是否已存在数据
     *
     * @param organizeId 组织ID
     * @param objectType 对象类型：岗位/角色/字典数据
     *                   岗位:PermissionConst.POSITION
     *                   角色:PermissionConst.ROLE
     *                   字典数据:PermissionConst.DICTIONARY
     * @return
     */
    Boolean existByObjTypeAndOrgId(String organizeId, String objectType);

    /**
     * 判断数据组织下面
     *
     * @param organizeId 组织ID
     * @param objectId   对象ID
     * @param objectType 对象类型：岗位/角色/字典数据
     *                   岗位:PermissionConst.POSITION
     *                   角色:PermissionConst.ROLE
     *                   字典数据:PermissionConst.DICTIONARY
     * @return
     */
    Boolean existByObejctIdAndOrgIdAndObjectType(String organizeId, String objectId, String objectType);

    /**
     * 根据对象类型以及组织ID查询关联数据
     *
     * @param objectType
     * @param orgId
     * @return
     */
    List<OrganizeRelationEntity> getListByTypeAndOrgId(String objectType, String orgId);

    /**
     * 根据对象Id和对象类型删除管理数据
     *
     * @param objectId   对象ID
     * @param objectType 对象类型
     * @return
     */
    Boolean deleteAllByObjectId(String objectId, String objectType);

    /*================ 切换组织后 -> 自动切换岗位 ===============*/

    /**
     * 自动获取当前组织下的默认岗位
     *
     * @param userId             用户ID
     * @param changeToMajorOrgId 切换组织ID
     * @param currentMajorPosId  原本的岗位ID
     * @return 岗位ID
     */
    String autoGetMajorPositionId(String userId, String changeToMajorOrgId, String currentMajorPosId);

    /**
     * 自动获取有权限的组织ID
     *
     * @param userId            用户ID
     * @param orgIds            组织ID集合
     * @param currentMajorOrgId 当前默认组织ID
     * @return 组织ID
     */
    String autoGetMajorOrganizeId(String userId, List<String> orgIds, String currentMajorOrgId);

    /**
     * 自动切换有权限的
     *
     * @param userIds 用户ID集合
     */
    void autoSetOrganize(List<String> userIds);

    /**
     * 自动切换岗位
     *
     * @param userIds 用户ID集合
     */
    void autoSetPosition(List<String> userIds);

    /**
     * 检查组织是否有权限
     *
     * @param userId 用户ID
     * @param orgId  组织ID
     * @return true:存在
     */
    Boolean checkBasePermission(String userId, String orgId);

    /**
     * @param organizeId 组织ID
     * @param objectId   对象ID
     * @param objectType 对象类型：岗位/角色/字典数据
     *                   岗位:PermissionConst.POSITION
     *                   角色:PermissionConst.ROLE
     *                   字典数据:PermissionConst.DICTIONARY
     * @throws PermissionException
     */
    void createOraganizeRelation(String organizeId, String objectId, String objectType) throws PermissionException;
}
