package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.model.online.BatchOnlineModel;
import com.bringspring.system.base.service.UserOnlineService;
import com.bringspring.system.message.model.UserOnlineModel;
import com.bringspring.system.message.model.UserOnlineVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 在线用户
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Api(tags = "在线用户", value = "Online")
@RestController
@RequestMapping("/api/system/OnlineUser")
public class UserOnlineController {

    @Autowired
    private UserOnlineService userOnlineService;

    /**
     * 列表
     *
     * @param page 分页参数
     * @return ignore
     */
    @ApiOperation("获取在线用户列表")
    @GetMapping
    public ActionResult list(Page page) {
        List<UserOnlineModel> data = userOnlineService.getList(page);
        List<UserOnlineVO> vo = JsonUtil.getJsonToList(data, UserOnlineVO.class);
        return ActionResult.success(vo);
    }

    /**
     * 注销
     *
     * @param id 主键值
     * @return ignore
     */
    @ApiOperation("强制下线")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        userOnlineService.delete(id);
        return ActionResult.success(MsgCode.SU005.get());
    }


    /**
     * 批量下线用户
     *
     * @param model 主键值
     * @return ignore
     */
    @ApiOperation("批量下线用户")
    @DeleteMapping
    public ActionResult clear(@RequestBody BatchOnlineModel model) {
        for (String id : model.getIds()) {
            userOnlineService.delete(id);
        }
        return ActionResult.success(MsgCode.SU005.get());
    }
}
