package com.bringspring.system.base.model.messagetemplate;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 新建消息模板
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-12-09
 */
@Data
public class MessageTemplateCrForm implements Serializable {
    /**
     * 分类（数据字典）
     */
    @NotBlank(message = "消息类型不能为空")
    private String category;

    /**
     * 模板名称
     */
    @NotBlank(message = "模板名称不能为空")
    private String fullName;

    /**
     * 标题
     */
    @NotBlank(message = "消息标题不能为空")
    private String title;

    /**
     * 是否站内信
     */
    private Integer isStationLetter;

    /**
     * 是否邮箱
     */
    private Integer isEmail;

    /**
     * 是否企业微信
     */
    private Integer isWecom;

    /**
     * 是否钉钉
     */
    private Integer isDingTalk;

    /**
     * 是否短信
     */
    private Integer isSms;

    /**
     * 短信模板ID
     */
    private String smsId;

    /**
     * 模板参数JSON
     */
    private String templateJson;

    /**
     * 内容
     */
    private String content;

    /**
     * 有效标志
     */
    private Integer enabledMark;

    private String enCode;

}
