package com.bringspring.system.base.model.province;

import com.bringspring.common.util.treeutil.SumTree;
import lombok.Data;


@Data
public class ProvinceModel extends SumTree {

    private String parentId;
    /**
     * 编码
     */
    private String enCode;
    /**
     * 名称
     */
    private String fullName;

    /**
     * 快速查询
     **/
    private String quickQuery;

    /**
     * 区域类型
     */
    private String type;
    /**
     * 城市级别：0 省份 1 直辖市，2 省会城市 ，3 地级市,4 县区
     */
    private Integer cityLevel;
    /**
     * 简称
     */
    private String provSimpleName;
    /**
     * 祖宗ids
     */
    private String parentIdTree;
    /**
     * 排序
     **/
    private Integer sortCode;

    /**
     * 有效标志
     **/
    private String enabledMark;
    /**
     * 描述
     **/
    private String description;

    /**
     * 创建时间
     */
    private Long creatorTime;
}
