package com.bringspring.system.base.util.jobutil;

import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.model.ContentModel;
import org.quartz.JobDataMap;
import org.springframework.stereotype.Component;


/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Component
public class TimeUtil {

    /**
     * 立即执行一次调度
     *
     * @param model    调度json
     * @param entity   实体
     * @param userInfo 用户信息
     */
    public static void startJobNow(ContentModel model, UserInfo userInfo, TimeTaskEntity entity, String token) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("content", model);
        jobDataMap.put("tenantId", userInfo.getTenantId());
        jobDataMap.put("tenantDbConnectionString", userInfo.getTenantDbConnectionString());
        jobDataMap.put("id", entity.getId());
        jobDataMap.put("type", entity.getExecuteType());
        jobDataMap.put("token", token);
        jobDataMap.put("timeTaskEntity",entity);
        String jobName = "AtOnce_" + entity.getId();
        String jobGroupName = entity.getGroupName();
        if (StringUtils.isNotEmpty(userInfo.getId())) {
            JobManager jobManager = new JobManager();
            jobManager.startJobNow(jobName, jobGroupName,  jobDataMap, TimeJob.class);
        }
    }

    /**
     * 立即执行调度
     *
     * @param model    调度json
     * @param entity   实体
     * @param userInfo 用户信息
     */
    public static void startJob(ContentModel model, UserInfo userInfo, TimeTaskEntity entity, String token) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("content", model);
        jobDataMap.put("tenantId", userInfo.getTenantId());
        jobDataMap.put("tenantDbConnectionString", userInfo.getTenantDbConnectionString());
        jobDataMap.put("id", entity.getId());
        jobDataMap.put("type", entity.getExecuteType());
        jobDataMap.put("token", token);
        jobDataMap.put("timeTaskEntity",entity);
        String jobName = entity.getId();
        String jobGroupName = entity.getGroupName();
        if (StringUtils.isNotEmpty(userInfo.getId())) {
            JobManager jobManager = new JobManager();
            String cron = entity.getExecuteCronExpression();  //执行周期(Cron表达式)
            // 移除任务
            jobManager.removeJob(jobName, jobGroupName);
            // 新增任务
            jobManager.addJob(jobName, jobGroupName, cron, jobDataMap, null, null, TimeJob.class);
        }
    }

    /**
     * 删除调度
     *
     * @param entity   实体
     * @param userInfo 用户信息
     */
    public static void removeJob(TimeTaskEntity entity, UserInfo userInfo) {
        JobManager jobManager = new JobManager();
        String jobName = entity.getId();
        String jobGroupName = entity.getGroupName();
        if (StringUtils.isNotEmpty(userInfo.getId())) {
            jobManager.removeJob(jobName, jobGroupName);
        }
    }

    /**
     * 可使用作为测试
     */
    @JsbosTask(fullName = "定时任务示例",description = "example" ,cron = "0 0 0 2 * ?")
    public static void testLocalTask(){
        System.out.println("定时任务示例");
    }



}
