package com.bringspring.system.message.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Pagination;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.message.entity.MessageEntity;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.model.message.NoticePagination;

import java.util.List;
import java.util.Map;

/**
 * 消息实例
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface MessageService extends IService<MessageEntity> {

    /**
     * 列表（通知公告）
     *
     * @param pagination
     * @return
     */
    List<MessageEntity> getNoticeList(NoticePagination pagination);

    /**
     * 只获取公告消息
     * @param pagination
     * @return
     */
    List<MessageEntity> getNoticeListByType(Pagination pagination,String type);


    /**
     * 列表（通知公告）
     *
     * @return
     */
    List<MessageEntity> getNoticeList();

    /**
     * 列表（通知公告）
     * 门户专用
     *
     * @return
     */
    List<MessageEntity> getDashboardNoticeList();

    /**
     * 列表（通知公告/系统消息/私信消息）
     *
     * @param pagination
     * @param type       类别
     * @return
     */
    List<MessageEntity> getMessageList(Pagination pagination, String type,String appid,String isShowRead);

    /**
     * 列表（通知公告/系统消息/私信消息）
     *
     * @param pagination
     * @param type       类别
     * @return
     */
    List<MessageEntity> getMessageList(Pagination pagination, String type);

    /**
     * 列表（通知公告/系统消息/私信消息）
     *
     * @param pagination
     * @param type       类别
     * @return
     */
    List<MessageEntity> getMessageList(Pagination pagination, String type,String userId,String appid,String isShowRead);

    /**
     * 列表（通知公告/系统消息/私信消息）
     *
     * @param pagination
     * @return
     */
    List<MessageEntity> getMessageList(Pagination pagination);

    /**
     * 信息
     *
     * @param id 主键值
     * @return
     */
    MessageEntity getinfo(String id);

    /**
     * 默认消息
     *
     * @param type 类别:1-通知公告/2-系统消息
     * @return
     */
    MessageEntity getInfoDefault(int type);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(MessageEntity entity);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(MessageEntity entity);

    /**
     * 更新
     *
     * @param entity 实体对象
     */
    boolean update(String id, MessageEntity entity);

    /**
     * 消息已读（单条）
     *
     * @param messageId 消息主键
     */
    MessageReceiveEntity messageRead(String messageId);

    /**
     * 消息已读（全部）
     */
    void messageRead();

    /**
     * 删除记录
     *
     * @param messageIds 消息Id
     */
    void deleteRecord(List<String> messageIds);

    /**
     * 获取未读数量（含 通知公告、系统消息）
     *
     * @param userId 用户主键
     */
    int getUnreadCount(String userId);

    /**
     * 获取公告未读数量
     *
     * @param userId 用户主键
     * @return
     */
    int getUnreadNoticeCount(String userId);

    /**
     * 获取消息未读数量
     *
     * @param userId 用户主键
     * @return
     */
    int getUnreadMessageCount(String userId);

    /**
     * 发送公告
     *
     * @param toUserIds 发送用户
     * @param entity    消息信息
     */
    void sentNotice(List<String> toUserIds, MessageEntity entity);

    /**
     * 发送消息
     *
     * @param toUserIds 发送用户
     * @param title     标题
     */
    void sentMessage(List<String> toUserIds,Integer type, String title);

    /**
     * 发送消息
     *
     * @param toUserIds 发送用户
     * @param title     标题
     * @param bodyText  内容
     */
    void sentMessage(List<String> toUserIds,Integer type, String title,String descripts, Map<String, String> bodyText);

    /**
     * 发送消息
     *
     * @param toUserIds  发送用户
     * @param title      标题
     * @param bodyText   内容
     * @param contentMsg 站内信息
     */
    void sentMessage(List<String> toUserIds, String title, String bodyText, Map<String, String> contentMsg);

    /**
     * 发送消息
     *
     * @param toUserIds 发送用户
     * @param entity    消息实体
     * @param parameterMap  参数
     */
    void sentTemplateMessage(List<String> toUserIds,Integer type, MessageTemplateEntity entity, Map<String, String> parameterMap,Map<String,String> bodyText);


    //新建任务发消息
    void newSendMessage(String tsakCode,String sendCode,String title,String content,String url,String PCurl,List<String> toUserIds,String type);

}
