package com.bringspring.system.msgcenter.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.*;
import com.bringspring.system.msgcenter.service.McTaskMsgContentService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.util.List;

/**
 * 业务场景消息内容表
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Slf4j
@RestController
@Api(tags = "业务场景消息内容表", value = "mcTaskMsgContent")
@RequestMapping("/api/msgCenter/mcTaskMsgContent")
public class McTaskMsgContentController {

    @Autowired
    private BaseDataUtil baseDataUtil;

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private McTaskMsgContentService mcTaskMsgContentService;


    /**
     * 列表
     *
     * @param mcTaskMsgContentPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody McTaskMsgContentPagination mcTaskMsgContentPagination) throws IOException {
        List<McTaskMsgContentEntity> list = mcTaskMsgContentService.getList(mcTaskMsgContentPagination);
        List<McTaskMsgContentListVO> listVO = JsonUtil.getJsonToList(list, McTaskMsgContentListVO.class);
        for (McTaskMsgContentListVO vo : listVO) {
            //处理id字段转名称，若无需转或者为空可删除
            vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(mcTaskMsgContentPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param mcTaskMsgContentCrForm
     * @return
     */
    @PostMapping
    public ActionResult create(@RequestBody @Valid McTaskMsgContentCrForm mcTaskMsgContentCrForm) throws DataException {
        mcTaskMsgContentService.create(mcTaskMsgContentCrForm);
        return ActionResult.success("创建成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<McTaskMsgContentInfoVO> info(@PathVariable("id") String id) {
        McTaskMsgContentEntity entity = mcTaskMsgContentService.getInfo(id);
        McTaskMsgContentInfoVO vo = JsonUtil.getJsonToBean(entity, McTaskMsgContentInfoVO.class);
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<McTaskMsgContentInfoVO> detailInfo(@PathVariable("id") String id) {
        McTaskMsgContentEntity entity = mcTaskMsgContentService.getInfo(id);
        McTaskMsgContentInfoVO vo = JsonUtil.getJsonToBean(entity, McTaskMsgContentInfoVO.class);
        //添加到详情表单对象中
        vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success(vo);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id,
                               @RequestBody @Valid McTaskMsgContentUpForm mcTaskMsgContentUpForm) throws DataException {
        McTaskMsgContentEntity entity = mcTaskMsgContentService.getInfo(id);
        if (entity != null) {
            mcTaskMsgContentService.update(id, mcTaskMsgContentUpForm);
            return ActionResult.success("更新成功");
        } else {
            return ActionResult.fail("更新失败，数据不存在");
        }
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        McTaskMsgContentEntity entity = mcTaskMsgContentService.getInfo(id);
        if (entity != null) {
            mcTaskMsgContentService.delete(entity);
        }
        return ActionResult.success("删除成功");
    }


}
