package com.bringspring.system.msgcenter.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;


/**
 * 业务场景消息表
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
@TableName("MC_TASK_MSG")
public class McTaskMsgEntity {

    @TableId("ID")
    private String id;

    @TableField("TASK_CODE")
    private String taskCode;

    @TableField("SEND_CODE")
    private String sendCode;

    @TableField("BUSINESS_KEY")
    private String businessKey;

    @TableField("TO_TYPE")
    private String toType;

    @TableField("TO_USER_IDS")
    private String toUserIds;

    @TableField("TO_DEPT_IDS")
    private String toDeptIds;

    @TableField("CUSTOM_KEY")
    private String customKey;

    @TableField("AUTO_AGAIN_MAX_NUM")
    private Integer autoAgainMaxNum;

    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    @TableField("DESCRIPTION")
    private String description;

    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.INSERT_UPDATE)
    private Date lastModifyTime;

    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;

}
