package com.bringspring.system.msgcenter.service.context;

import com.bringspring.common.base.UserInfo;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import lombok.Data;

import java.util.List;

/**
 * 根据message_receive数据，渠道消息下发
 * 参数封装传递
 */
@Data
public class SendReceiveParam {
    /**
     * 当前用户信息，不可为空
     */
    private UserInfo currentUserInfo;
    /**
     * 原始消息，不可为空
     */
    private McTaskMsgEntity taskMsg;
    /**
     * 发送配置，消息模板组合列表 不可为空
     */
    private List<McMsgSendTemplateModel> sendTemplateList;
    /**
     * 渠道消息发送状态，不指定则默认未发送成功的 0
     */
    private Integer enabledMark;
}
