package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgcenter.mapper.McMsgTemplateMapper;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateCrForm;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplatePagination;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateUpForm;
import com.bringspring.system.msgcenter.service.McMsgTemplateFieldService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import com.bringspring.system.msgcenter.constant.Constants.Uniqueness;

/**
 * 消息模板表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-07
 */
@Service
public class McMsgTemplateServiceImpl extends ServiceImpl<McMsgTemplateMapper, McMsgTemplateEntity> implements McMsgTemplateService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private McMsgTemplateFieldService mcMsgTemplateFieldService;


    @Override
    public List<McMsgTemplateEntity> getList(McMsgTemplatePagination pagination) {
        List<String> AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper<McMsgTemplateEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getTemplateType())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getTemplateType, pagination.getTemplateType());
        }

        if (StringUtils.isNotEmpty(pagination.getMessageType())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageType, pagination.getMessageType());
        }

        if (StringUtils.isNotEmpty(pagination.getMessageSource())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, pagination.getMessageSource());
        }

        // 关键字查询
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            
            queryWrapper.lambda().like(McMsgTemplateEntity::getFullName, pagination.getKeyword())
                    .or().like(McMsgTemplateEntity::getEnCode, pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            
            queryWrapper.lambda().like(McMsgTemplateEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            
            queryWrapper.lambda().like(McMsgTemplateEntity::getEnCode, pagination.getEnCode());
        }

        if (StringUtils.isNotEmpty(pagination.getSubscriberType())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getSubscriberType, pagination.getSubscriberType());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgTemplateEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByAsc(McMsgTemplateEntity::getSortCode);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McMsgTemplateEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<McMsgTemplateEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
            IPage<McMsgTemplateEntity> userIPage = this.page(page, queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<McMsgTemplateEntity> list = new ArrayList();
            return pagination.setData(list, list.size());
        }
    }

    @Override
    public List<McMsgTemplateEntity> getTypeList(McMsgTemplatePagination pagination, String dataType) {
        List<String> AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper<McMsgTemplateEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getTemplateType())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getTemplateType, pagination.getTemplateType());
        }

        if (StringUtils.isNotEmpty(pagination.getMessageType())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageType, pagination.getMessageType());
        }

        if (StringUtils.isNotEmpty(pagination.getMessageSource())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, pagination.getMessageSource());
        }

        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            
            queryWrapper.lambda().like(McMsgTemplateEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            
            queryWrapper.lambda().like(McMsgTemplateEntity::getEnCode, pagination.getEnCode());
        }

        if (StringUtils.isNotEmpty(pagination.getSubscriberType())) {
            
            queryWrapper.lambda().eq(McMsgTemplateEntity::getSubscriberType, pagination.getSubscriberType());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgTemplateEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByAsc(McMsgTemplateEntity::getSortCode);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McMsgTemplateEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<McMsgTemplateEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
                IPage<McMsgTemplateEntity> userIPage = this.page(page, queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<McMsgTemplateEntity> list = new ArrayList();
                return pagination.setData(list, list.size());
            }
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public List<McMsgTemplateEntity> getInfoByCode(String enCode) {
        QueryWrapper<McMsgTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, enCode);
        queryWrapper.lambda().eq(McMsgTemplateEntity::getEnabledMark, EnabledMarkEnum.ENABLE.getCode()); // 状态：启用
        queryWrapper.lambda().orderByAsc(McMsgTemplateEntity::getEnCode);
        return this.list(queryWrapper);
    }

    @Override
    public McMsgTemplateEntity getInfo(String id) {
        QueryWrapper<McMsgTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgTemplateEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McMsgTemplateCrForm mcMsgTemplateCrForm) {
        McMsgTemplateEntity entity = JsonUtil.getJsonToBean(mcMsgTemplateCrForm, McMsgTemplateEntity.class);
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        this.save(entity);
        List<McMsgTemplateFieldEntity> fieldList =
                JsonUtil.getJsonToList(mcMsgTemplateCrForm.getFieldList(), McMsgTemplateFieldEntity.class);
        for (McMsgTemplateFieldEntity entitys : fieldList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setTemplateId(entity.getId());
            mcMsgTemplateFieldService.save(entitys);
        }

    }

    @Override
    @DSTransactional
    public boolean update(String id, McMsgTemplateUpForm mcMsgTemplateUpForm) {
        McMsgTemplateEntity entity = JsonUtil.getJsonToBean(mcMsgTemplateUpForm, McMsgTemplateEntity.class);
        entity.setId(id);

        QueryWrapper<McMsgTemplateFieldEntity> fieldQueryWrapper = new QueryWrapper<>();
        fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, entity.getId());
        mcMsgTemplateFieldService.remove(fieldQueryWrapper);

        List<McMsgTemplateFieldEntity> fieldList =
                JsonUtil.getJsonToList(mcMsgTemplateUpForm.getFieldList(), McMsgTemplateFieldEntity.class);
        for (McMsgTemplateFieldEntity entitys : fieldList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setTemplateId(entity.getId());
            mcMsgTemplateFieldService.save(entitys);
        }

        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McMsgTemplateEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
            QueryWrapper<McMsgTemplateFieldEntity> fieldQueryWrapper = new QueryWrapper<>();
            fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, entity.getId());
            mcMsgTemplateFieldService.remove(fieldQueryWrapper);
        }
    }

    //子表方法
    @Override
    public List<McMsgTemplateFieldEntity> getMcMsgTemplateFieldList(String id) {
        QueryWrapper<McMsgTemplateFieldEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, id);
        return mcMsgTemplateFieldService.list(queryWrapper);
    }


    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper<McMsgTemplateEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgTemplateEntity::getEnCode, enCode);
        queryWrapper.last("limit 1");
        McMsgTemplateEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return Uniqueness.NOT_UNIQUE;
        }
        return Uniqueness.UNIQUE;
    }

    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper<McMsgTemplateEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgTemplateEntity::getFullName, fullName);
        queryWrapper.last("limit 1");
        McMsgTemplateEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return Uniqueness.NOT_UNIQUE;
        }
        return Uniqueness.UNIQUE;
    }

    @Override
    public long getCountByMessageSource(String messageSource) {
        LambdaQueryWrapper<McMsgTemplateEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgTemplateEntity::getMessageSource, messageSource);
        return this.count(queryWrapper);
    }

}