package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 用户信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName(value = "BASE_USER")
public class UserEntity implements Serializable {
    /**
     * 用户主键
     */
    @TableId("ID")
    private String id;

    @TableField("CODE")
    private String code;
    /**
     * 账户
     */
    @TableField("ACCOUNT")
    private String account;

    /**
     * 姓名
     */
    @TableField("REALLY_NAME")
    private String realName;

    /**
     * 快速查询
     */
    @TableField("QUICK_QUERY")
    private String quickQuery;

    /**
     * 呢称
     */
    @TableField("NICK_NAME")
    private String nickName;

    /**
     * 头像
     */
    @TableField("HEAD_ICON")
    private String headIcon;

    /**
     * 性别
     */
    @TableField("GENDER")
    private Integer gender;

    /**
     * 生日
     */
    @TableField(value = "BIRTHDAY")
    private Date birthday;

    /**
     * 手机
     */
    @TableField("MOBILE_PHONE")
    private String mobilePhone;

    /**
     * 电话
     */
    @TableField("TELEPHONE")
    private String telePhone;

    /**
     * Landline
     */
    @TableField("LANDLINE")
    private String landline;

    /**
     * 邮箱
     */
    @TableField("EMAIL")
    private String email;

    /**
     * 民族
     */
    @TableField("NATION")
    private String nation;

    /**
     * 籍贯
     */
    @TableField("NATIVE_PLACE")
    private String nativePlace;

    /**
     * 入职日期
     */
    @TableField(value = "ENTRY_DATE", fill = FieldFill.UPDATE)
    private Date entryDate;

    /**
     * 证件类型
     */
    @TableField("CERTIFICATES_TYPE")
    private String certificatesType;

    /**
     * 证件号码
     */
    @TableField("CERTIFICATES_NUMBER")
    private String certificatesNumber;

    /**
     * 文化程度
     */
    @TableField("EDUCATION")
    private String education;

    /**
     * UrgentContacts
     */
    @TableField("URGENT_CONTACTS")
    private String urgentContacts;

    /**
     * 紧急电话
     */
    @TableField("URGENT_TELEPHONE")
    private String urgentTelePhone;

    /**
     * 通讯地址
     */
    @TableField("POSTAL_ADDRESS")
    private String postalAddress;

    /**
     * 自我介绍
     */
    @TableField("SIGNATURE")
    private String signature;

    /**
     * 密码
     */
    @TableField("PASSWORD")
    private String password;

    /**
     * 秘钥
     */
    @TableField("SECRETKEY")
    private String secretkey;

    /**
     * 首次登录时间
     */
    @TableField("FIRST_LOGIN_TIME")
    private Date irstLogTime;

    /**
     * 首次登录IP
     */
    @TableField("FIRST_LOGIN_IP")
    private String firstLogIp;

    /**
     * 前次登录时间
     */
    @TableField("PREVIOUS_LOGIN_TIME")
    private Date prevLogTime;

    /**
     * 前次登录IP
     */
    @TableField("PREVIOUS_LOGIN_IP")
    private String prevLogIp;

    /**
     * 最后登录时间
     */
    @TableField("LAST_LOGIN_TIME")
    private Date lastLogTime;

    /**
     * 最后登录IP
     */
    @TableField("LAST_LOGIN_IP")
    private String lastLogIp;

    /**
     * 登录成功次数
     */
    @TableField("LOGIN_SUCCESS_COUNT")
    private Integer logSuccessCount;

    /**
     * 登录错误次数
     */
    @TableField("LOGIN_ERROR_COUNT")
    private Integer logErrorCount;

    /**
     * 最后修改密码时间
     */
    @TableField("CHANGE_PASSWORD_DATE")
    private Date changePasswordDate;

    /**
     * 系统语言
     */
    @TableField("LANGUAGE")
    private String language;

    /**
     * 系统样式
     */
    @TableField("THEME")
    private String theme;

    /**
     * 常用菜单
     */
    @TableField("COMMON_MENU")
    private String commonMenu;

    /**
     * 是否管理员
     */
    @TableField("IS_ADMINISTRATOR")
    private Integer isAdministrator;

    /**
     * 扩展属性
     */
    @TableField("PROPERTY_JSON")
    private String propertyJson;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode=0L;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.INSERT_UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;

    /**
     * 删除时间
     */
    @TableField(value = "DELETE_TIME", updateStrategy = FieldStrategy.IGNORED)
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField(value = "DELETE_USER_ID", updateStrategy = FieldStrategy.IGNORED)
    private String deleteUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 主管主键
     */
    @TableField("MANAGER_ID")
    private String managerId;

    /**
     * 组织主键
     */
    @TableField("ORGANIZE_ID")
    private String organizeId;

    /**
     * 岗位主键
     */
    @TableField("POSITION_ID")
    private String positionId;

    /**
     * 角色主键
     */
    @TableField("ROLE_ID")
    private String roleId;

    /**
     * 门户主键
     */
    @TableField("PORTAL_ID")
    private String portalId;

    /**
     * 锁定标志
     */
    @TableField("LOCK_MARK")
    private Integer lockMark;

    /**
     * 解锁时间
     */
    @TableField(value = "UNLOCK_TIME", updateStrategy = FieldStrategy.IGNORED)
    private Date unlockTime;

    @TableField("GROUP_ID")
    private String groupId;

    @TableField(exist = false)
    private String addressList;

    @TableField(exist = false)
    private List<String> authorizeAddress;

    @TableField(exist = false)
    private List<String> afterAuthorizeAddress;

    @TableField(exist = false)
    private List<String> executeAddress;

    @TableField(exist = false)
    private String areaManagerFlag;

    @TableField(exist = false)
    private String authorizeType;


}
