package com.bringspring.system.permission.model.authorize;

/**
 * 数据权限过滤条件字段
 * @author RKKJ开发平台组
 * @version V3.2
 * @copyright 荣科科技股份有限公司
 * @date  2021/10/9
 */
public enum AuthorizeConditionEnum {
	/**
	 * 任意文本
	 */
	TEXT("text"),
	/**
	 * 当前公司
	 */
	COMPANY("@companyId"),
	/**
	 * 当前部门
	 */
	ORGANIZE("@organizeId"),
	/**
	 * 当前部门人员的
	 */
	ORGANIZE_USER("@organizeIdUser"),
	/**
	 * 当前组织及子组织
	 */
	ORGANIZEANDUNDER("@organizationAndSuborganization"),
	/**
	 * 当前组织及子组织下属人员的
	 */
	ORGANIZEANDUNDER_USER("@organizationAndSuborganizationUser"),
	/**
	 * 当前用户
	 */
	USER("@userId"),
	/**
	 * 当前用户及下属
	 */
	USERANDUNDER("@userAraSubordinates"),
	/**
	 * 授权区域内的人员
	 */
	AUTH_AREA_USER("@authAreaUser"),
	/**
	 * 授权区域内的客户
	 */
	AUTH_AREA_CUSTOMER("@authAreaCustomer"),
	/**
	 * 包含
	 */
	Include("include");
	;
	private String condition;

	AuthorizeConditionEnum(String condition) {
		this.condition = condition;
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}
}
