package com.bringspring.system.permission.model.usergroup;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/11 9:34
 */
@Data
public class GroupUpForm implements Serializable {

    /**
     * 名称
     **/
    @ApiModelProperty("名称")
    @NotBlank(message = "名称不能为空")
    private String fullName;

    /**
     * 编码
     **/
    @ApiModelProperty("编码")
    @NotBlank(message = "编码不能为空")
    private String enCode;

    /**
     * 说明
     **/
    @ApiModelProperty("说明")
    private String description;

    /**
     * 类型
     **/
    @ApiModelProperty("类型")
    @NotBlank(message = "类型不能为空")
    private String type;

    /**
     * 排序
     **/
    @ApiModelProperty("排序")
    private String sortCode;

    /**
     * 组长
     */
    @TableField("groupLeader")
    private String groupLeader;

}
