package com.bringspring.system.permission.service;

import com.bringspring.common.base.Page;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.user.mod.RangeElementModel;
import com.bringspring.system.permission.model.user.vo.RangeElementSelectorVO;
import com.bringspring.system.permission.model.user.vo.UserSelectorVO;

import java.util.List;
import java.util.Map;

/**
 * 限定人员范围
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface RangeService {

    /**
     * 获取范围限定前端组件回显数据
     *
     * @param selected
     * @return
     */
    Map<String, Object> getRangeElementSelected(List<RangeElementModel> selected);

    /**
     * 获取范围限定的用户列表
     *
     * @param selected
     * @return
     */
    List<UserEntity> getRangeElementUserList(List<RangeElementModel> selected);

    /**
     * 获取范围限定前端组件数据
     *
     * @param tab
     * @param page
     * @return
     */
    List<RangeElementSelectorVO> getOrganizeUserList(String tab, Page page);

    /**
     * 获取范围限定前端组件回显数据
     *
     * @param selected
     * @return
     */
    List<RangeElementSelectorVO> getOrganizeUserList(List<RangeElementModel> selected);

    /**
     * 获取限定范围的用户列表
     *
     * @param selected
     * @return
     */
    List<UserSelectorVO> getRangeUserList(List<RangeElementModel> selected);

    /**
     * 获取范围限定的用户列表
     *
     * @param rangeStr
     * @return
     */
    List<UserEntity> getRangeUserList(String rangeStr);

}
