/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.SmsTemplateEntity;
import com.bringspring.system.base.model.smstemplate.SmsTemplateCrForm;
import com.bringspring.system.base.model.smstemplate.SmsTemplateListVO;
import com.bringspring.system.base.model.smstemplate.SmsTemplateSelector;
import com.bringspring.system.base.model.smstemplate.SmsTemplateUpForm;
import com.bringspring.system.base.model.smstemplate.SmsTemplateVO;
import com.bringspring.system.base.model.systemconfig.SmsModel;
import com.bringspring.system.base.service.SmsTemplateService;
import com.bringspring.system.base.util.SmsUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="SmsTemplateController", tags={"\u77ed\u4fe1\u6a21\u677f\u63a7\u5236\u7c7b"})
@RestController
@RequestMapping(value={"/api/system/SmsTemplate"})
public class SmsTemplateController {
    @Autowired
    private SmsTemplateService smsTemplateService;

    @ApiOperation(value="\u77ed\u4fe1\u6a21\u677f\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<SmsTemplateListVO>> list(Pagination pagination) {
        List<SmsTemplateEntity> list = this.smsTemplateService.getList(pagination);
        List listVO = JsonUtil.getJsonToList(list, SmsTemplateListVO.class);
        for (SmsTemplateListVO smsTemplateListVO : listVO) {
            if ("1".equals(smsTemplateListVO.getCompany())) {
                smsTemplateListVO.setCompany("\u963f\u91cc");
                continue;
            }
            if (!"2".equals(smsTemplateListVO.getCompany())) continue;
            smsTemplateListVO.setCompany("\u817e\u8baf");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u77ed\u4fe1\u6a21\u677f\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<SmsTemplateSelector>> selector() {
        List<SmsTemplateEntity> list = this.smsTemplateService.getList();
        List jsonToList = JsonUtil.getJsonToList(list, SmsTemplateSelector.class);
        for (SmsTemplateSelector smsTemplateSelector : jsonToList) {
            if ("1".equals(smsTemplateSelector.getCompany())) {
                smsTemplateSelector.setCompany("\u963f\u91cc");
                continue;
            }
            if (!"2".equals(smsTemplateSelector.getCompany())) continue;
            smsTemplateSelector.setCompany("\u817e\u8baf");
        }
        ListVO listVO = new ListVO();
        listVO.setList(jsonToList);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u77ed\u4fe1\u6a21\u677f")
    @GetMapping(value={"/{id}"})
    public ActionResult<SmsTemplateVO> info(@PathVariable(value="id") String id) {
        SmsTemplateEntity entity = this.smsTemplateService.getInfo(id);
        SmsTemplateVO vo = (SmsTemplateVO)JsonUtil.getJsonToBean((Object)entity, SmsTemplateVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa")
    @PostMapping
    public ActionResult<String> create(@RequestBody @Valid SmsTemplateCrForm smsTemplateCrForm) {
        SmsTemplateEntity entity = (SmsTemplateEntity)JsonUtil.getJsonToBean((Object)smsTemplateCrForm, SmsTemplateEntity.class);
        if (this.smsTemplateService.isExistByTemplateName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.smsTemplateService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.smsTemplateService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/{id}"})
    public ActionResult<String> update(@PathVariable(value="id") String id, @RequestBody @Valid SmsTemplateUpForm smsTemplateUpForm) {
        SmsTemplateEntity entity = (SmsTemplateEntity)JsonUtil.getJsonToBean((Object)smsTemplateUpForm, SmsTemplateEntity.class);
        if (this.smsTemplateService.isExistByTemplateName(entity.getFullName(), id)) {
            return ActionResult.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.smsTemplateService.isExistByEnCode(entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.smsTemplateService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult<String> delete(@PathVariable(value="id") String id) {
        SmsTemplateEntity entity = this.smsTemplateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        this.smsTemplateService.delete(entity);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult<String> update(@PathVariable(value="id") String id) {
        SmsTemplateEntity entity = this.smsTemplateService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == 0) {
                entity.setEnabledMark(1);
            } else {
                entity.setEnabledMark(0);
            }
            boolean flag = this.smsTemplateService.update(id, entity);
            if (!flag) {
                return ActionResult.fail((String)MsgCode.FA002.get());
            }
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u53c2\u6570")
    @PostMapping(value={"/getTemplate"})
    public ActionResult<?> testConnect(@RequestBody SmsTemplateCrForm smsTemplateCrForm) {
        List<String> list = null;
        if (smsTemplateCrForm != null) {
            SmsModel smsModel = this.smsTemplateService.getSmsConfig();
            list = SmsUtil.querySmsTemplateRequest(smsTemplateCrForm.getCompany(), smsModel, smsTemplateCrForm.getEndpoint(), smsTemplateCrForm.getRegion(), smsTemplateCrForm.getTemplateId());
        }
        if (list == null) {
            return ActionResult.fail((String)"\u77ed\u4fe1\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u77ed\u4fe1\u6a21\u677f\u53c2\u6570")
    @GetMapping(value={"/getTemplate/{id}"})
    public ActionResult<?> getTemplateById(@PathVariable(value="id") String id) {
        List<Object> list = new ArrayList();
        SmsTemplateEntity entity = this.smsTemplateService.getInfo(id);
        if (entity != null && entity.getCompany() != null) {
            SmsModel smsModel = this.smsTemplateService.getSmsConfig();
            list = SmsUtil.querySmsTemplateRequest(entity.getCompany(), smsModel, entity.getEndpoint(), entity.getRegion(), entity.getTemplateId());
        }
        if (list == null) {
            return ActionResult.success(new ArrayList());
        }
        return ActionResult.success(list);
    }

    @ApiOperation(value="\u53d1\u9001\u6d4b\u8bd5\u77ed\u4fe1")
    @PostMapping(value={"/testSent"})
    public ActionResult testSentSms(@RequestBody SmsTemplateCrForm smsTemplateCrForm) {
        if (smsTemplateCrForm.getCompany() != null) {
            SmsModel smsModel = this.smsTemplateService.getSmsConfig();
            String sentCode = SmsUtil.sentSms(smsTemplateCrForm.getCompany(), smsModel, smsTemplateCrForm.getEndpoint(), smsTemplateCrForm.getRegion(), smsTemplateCrForm.getPhoneNumbers(), smsTemplateCrForm.getSignContent(), smsTemplateCrForm.getTemplateId(), smsTemplateCrForm.getParameters());
            if ("OK".equalsIgnoreCase(sentCode)) {
                return ActionResult.success((String)"\u9a8c\u8bc1\u901a\u8fc7");
            }
        }
        return ActionResult.fail((String)"\u9a8c\u8bc1\u5931\u8d25");
    }
}

