/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.ModuleDataAuthorizeEntity;
import com.bringspring.system.base.mapper.ModuleDataAuthorizeMapper;
import com.bringspring.system.base.service.ModuleDataAuthorizeService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleDataAuthorizeServiceImpl
extends ServiceImpl<ModuleDataAuthorizeMapper, ModuleDataAuthorizeEntity>
implements ModuleDataAuthorizeService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ModuleDataAuthorizeEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleDataAuthorizeEntity::getSortCode)).orderByDesc(ModuleDataAuthorizeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleDataAuthorizeEntity> getList(String moduleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeEntity::getModuleId, (Object)moduleId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleDataAuthorizeEntity::getSortCode)).orderByDesc(ModuleDataAuthorizeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ModuleDataAuthorizeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeEntity::getId, (Object)id);
        return (ModuleDataAuthorizeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(ModuleDataAuthorizeEntity entity) {
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
            entity.setEnabledMark(1);
            entity.setSortCode(RandomUtil.parses());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, ModuleDataAuthorizeEntity entity) {
        entity.setId(id);
        entity.setEnabledMark(1);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(ModuleDataAuthorizeEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public boolean isExistByEnCode(String moduleId, String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeEntity::getModuleId, (Object)moduleId);
        queryWrapper.lambda().eq(ModuleDataAuthorizeEntity::getEnCode, (Object)enCode);
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByFullName(String moduleId, String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleDataAuthorizeEntity::getModuleId, (Object)moduleId);
        queryWrapper.lambda().eq(ModuleDataAuthorizeEntity::getFullName, (Object)fullName);
        return this.count((Wrapper)queryWrapper) > 0L;
    }
}

