/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.config.mutil;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.message.MyDingTalkModel;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DingTalkConfiguration {
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    private Map<String, MyDingTalkModel> dingTalkModels = Maps.newHashMap();

    public Map<String, MyDingTalkModel> getDingTalkModels() {
        return this.dingTalkModels;
    }

    public MyDingTalkModel getDingTalkModel(String corpId) {
        MyDingTalkModel dingTalkModel = this.dingTalkModels.get(corpId);
        if (ObjectUtil.isEmpty((Object)dingTalkModel)) {
            this.initModels();
            dingTalkModel = this.dingTalkModels.get(corpId);
        }
        return dingTalkModel;
    }

    public void initModels() {
        try {
            List<McMsgAccountEntity> account = this.mcMsgAccountService.getAccountByCategory(ChannelTypeEnum.DING_MSG.getCode());
            if (CollectionUtil.isEmpty(account)) {
                throw new WxRuntimeException("\u672a\u6dfb\u52a0\u963f\u91cc\u9489\u9489\u76f8\u5173\u5e94\u7528\u914d\u7f6e\uff01");
            }
            ArrayList listModel = new ArrayList();
            account.stream().forEach(a -> {
                MyDingTalkModel dingModel = new MyDingTalkModel();
                dingModel.setAccountConfigId(a.getId());
                dingModel.setName(a.getFullName());
                dingModel.setCorpId(a.getEnterpriseId());
                dingModel.setApiToken(a.getBearer());
                dingModel.setAppId(a.getAppId());
                dingModel.setAgentId(a.getAgentId());
                dingModel.setClientId(a.getAppKey());
                dingModel.setClientSecrent(a.getAppSecret());
                dingModel.setDingMobileUrl(a.getAddress());
                listModel.add(dingModel);
            });
            SysConfigEntity dingComInfo = this.sysConfigService.getConfigByKeyName("dingCom");
            if (ObjectUtil.isNotEmpty((Object)dingComInfo) && StringUtils.isNotEmpty((String)dingComInfo.getKeyValue())) {
                String keyValue = dingComInfo.getKeyValue();
                List sysConfig = JsonUtil.getJsonToList((String)keyValue, MyDingTalkModel.class);
                sysConfig.stream().forEach(a -> listModel.stream().forEach(b -> {
                    if (b.getAccountConfigId().equals(a.getAccountConfigId())) {
                        b.setDingSynIsSynOrg(a.getDingSynIsSynOrg());
                        b.setDingSynIsSynUser(a.getDingSynIsSynUser());
                        b.setOrgParent(a.getOrgParent());
                    }
                }));
            }
            this.dingTalkModels = listModel.stream().collect(Collectors.toMap(model -> model.getCorpId(), a -> a));
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }
}

