/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.constant.DictType;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.service.McMsgSendService;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.util.concurrent.Executor;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e1a\u52a1\u6d88\u606f\u53d1\u9001\u63a5\u53e3\u670d\u52a1"}, value="messageService")
@RequestMapping(value={"/api/outer/messageService"})
public class MsgCenterService {
    private static final Logger log = LoggerFactory.getLogger(MsgCenterService.class);
    @Autowired
    private Executor threadPoolExecutor;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @PostMapping(value={"/taskMsg/send"})
    public ActionResult create(@RequestBody @Valid TaskMsg taskMsg) throws DataException {
        String operation = "\u4e1a\u52a1\u6d88\u606f\u53d1\u9001";
        if (ObjectUtil.isEmpty((Object)taskMsg)) {
            return this.buildFailedResult("\u4e1a\u52a1\u6d88\u606f\u53d1\u9001", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String error = this.validateTaskCode(taskMsg.getTaskCode(), "\u4e1a\u52a1\u6d88\u606f\u53d1\u9001");
        if (error != null) {
            return ActionResult.fail((String)error);
        }
        error = this.validateSendCode(taskMsg.getSendCode(), "\u4e1a\u52a1\u6d88\u606f\u53d1\u9001");
        if (error != null) {
            return ActionResult.fail((String)error);
        }
        error = this.validateBusinessKey(taskMsg.getBusinessKey(), "\u4e1a\u52a1\u6d88\u606f\u53d1\u9001");
        if (error != null) {
            return ActionResult.fail((String)error);
        }
        error = this.validateReceivers(taskMsg.getToUserIds(), taskMsg.getToDeptIds(), "\u4e1a\u52a1\u6d88\u606f\u53d1\u9001");
        if (error != null) {
            return ActionResult.fail((String)error);
        }
        this.submitAsyncSendTask(taskMsg);
        return ActionResult.success((String)"\u53d1\u9001\u6210\u529f");
    }

    private void submitAsyncSendTask(TaskMsg taskMsg) {
        this.threadPoolExecutor.execute(() -> {
            try {
                this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
            }
            catch (Exception e) {
                log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    private ActionResult buildFailedResult(String operation, String reason) {
        String errorMsg = String.format("%s\uff0c\u5931\u8d25\uff1a%s", operation, reason);
        log.error(errorMsg);
        return ActionResult.fail((String)errorMsg);
    }

    private String validateTaskCode(String taskCode, String operation) {
        if (StringUtils.isEmpty((String)taskCode)) {
            return this.buildFailedMsg(operation, "taskCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)this.baseDataUtil.getDictName(taskCode, DictType.TASK_CODE.getCode()))) {
            return this.buildFailedMsg(operation, "taskCode\u672a\u6388\u6743");
        }
        return null;
    }

    private String validateSendCode(String sendCode, String operation) {
        if (StringUtils.isEmpty((String)sendCode)) {
            return this.buildFailedMsg(operation, "sendCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)this.mcMsgSendService.getValidInfo(sendCode))) {
            return this.buildFailedMsg(operation, "sendCode\u4e0d\u5b58\u5728\u6216\u7981\u7528");
        }
        return null;
    }

    private String validateBusinessKey(BusinessKeys businessKey, String operation) {
        if (ObjectUtil.isEmpty((Object)businessKey)) {
            return this.buildFailedMsg(operation, "businessKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    private String validateReceivers(String userIds, String deptIds, String operation) {
        if (StringUtils.isEmpty((String)userIds) && StringUtils.isEmpty((String)deptIds)) {
            return this.buildFailedMsg(operation, "\u65e0\u6548\u7684\u63a5\u6536\u4eba");
        }
        return null;
    }

    private String buildFailedMsg(String operation, String reason) {
        return String.format("%s\uff0c\u5931\u8d25\uff1a%s", operation, reason);
    }
}

