/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.chain;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.MsgCenterCode;
import com.bringspring.system.msgcenter.service.chain.FilterProcessor;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class BlacklistFilter
implements FilterProcessor {
    @Override
    public FilterResult process(SendMessageContext context) {
        Map<Boolean, List<McTaskMsgReceiveEntity>> partitioned = BlacklistUtil.receiveListPartitioned(context.getReceiveList());
        List<McTaskMsgReceiveEntity> invalidList = partitioned.get(true);
        if (CollectionUtil.isNotEmpty(invalidList)) {
            invalidList.stream().forEach(e -> {
                e.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                e.setDescription(MsgCenterCode.BLACKLIST_USER.getDesc() + ":" + e.getSysUserId());
            });
        }
        return new FilterResult(partitioned.get(false), invalidList);
    }
}

