/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.chain;

import cn.hutool.core.collection.CollUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.MsgCenterCode;
import com.bringspring.system.msgcenter.service.chain.FilterProcessor;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThirdInfoFilter
implements FilterProcessor {
    @Autowired
    private SynThirdInfoService synThirdInfoService;

    @Override
    public FilterResult process(SendMessageContext context) {
        List thirdIds = context.getValidList().stream().map(McTaskMsgReceiveEntity::getReceiveUserId).collect(Collectors.toList());
        List thirdInfoList = this.synThirdInfoService.listByIds(thirdIds);
        Map<String, SynThirdInfoEntity> infoMap = thirdInfoList.stream().collect(Collectors.toMap(SynThirdInfoEntity::getId, Function.identity()));
        context.setThirdInfoMap(infoMap);
        Map<Boolean, List<McTaskMsgReceiveEntity>> partitioned = context.getValidList().stream().collect(Collectors.partitioningBy(r -> infoMap.containsKey(r.getReceiveUserId())));
        List<McTaskMsgReceiveEntity> invalidList = partitioned.get(false);
        if (CollUtil.isNotEmpty(invalidList)) {
            invalidList.stream().forEach(e -> {
                e.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                e.setDescription(MsgCenterCode.THIRD_PARTY_INFO_MISSING.getDesc() + "\uff1a" + e.getReceiveUserId());
            });
        }
        return new FilterResult(partitioned.get(true), invalidList);
    }
}

