package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 数据接口调用日志
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-06-03
 */
@Data
@TableName("BASE_DATA_INTERFACE_LOG")
public class DataInterfaceLogEntity implements Serializable {

    /**
     * 主键id
     */
    @TableId("ID")
    private String id;

    /**
     * 调用接口id
     */
    @TableField("INVOK_ID")
    private String invokId;

    /**
     * 调用时间
     */
    @TableField(value = "INVOK_TIME", fill = FieldFill.INSERT)
    private Date invokTime;

    /**
     * 调用者id
     */
    @TableField("INVOK_USER_ID")
    private String userId;

    /**
     * 请求ip
     */
    @TableField("INVOK_IP")
    private String invokIp;

    /**
     * 请求设备
     */
    @TableField("INVOK_DEVICE")
    private String invokDevice;

    /**
     * 请求类型
     */
    @TableField("INVOK_TYPE")
    private String invokType;

    /**
     * 请求耗时
     */
    @TableField("INVOK_WASTE_TIME")
    private Integer invokWasteTime;

}
