package com.bringspring.system.base.exception;

import lombok.Data;

import java.util.Map;

/**
 * 自定义的运行时异常类，用于存储校验错误信息
 */
@Data
public class ExcelValidationException extends RuntimeException {
    /**
     * 错误代码
     */
    private int code;
    /**
     * 错误信息
     */
    private String errorMessage;
    /**
     * 表单错误信息
     */
    private Map<String, String> errorMessages;

    public ExcelValidationException(String errorMessage) {
        super(errorMessage);
        this.errorMessage = errorMessage;
    }

    public ExcelValidationException(int code, String errorMessage) {
        super(errorMessage);
        this.code = code;
        this.errorMessage = errorMessage;
    }

    public ExcelValidationException(Map<String, String> errorMessages) {
        super();
        this.errorMessages = errorMessages;
    }

}
