package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.system.base.entity.BaseVersionEntity;
import com.bringspring.system.base.model.baseversion.BaseVersionCrForm;
import com.bringspring.system.base.model.baseversion.BaseVersionPagination;
import com.bringspring.system.base.model.baseversion.BaseVersionUpForm;


import java.util.List;

/**
 *
 * 系统版本管理
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-01-13
 */
public interface BaseVersionService extends IService<BaseVersionEntity> {

    /**
     * 系统版本管理列表分页查询
     * @param baseVersionPagination 查询参数
     * @return List<BaseVersionEntity>
     */
    List<BaseVersionEntity> getList(BaseVersionPagination baseVersionPagination);
    /**
     * 系统版本管理列表分页查询（导出使用）
     * @param baseVersionPagination 查询参数
     * @param dataType 0-当前页；非0-当前查询条件所有数据
     * @return List<BaseVersionEntity>
     */
    List<BaseVersionEntity> getTypeList(BaseVersionPagination baseVersionPagination,String dataType);


    /**
     * 获取系统版本管理详细信息
     * @param id 主键
     * @return BaseVersionEntity
     */
    BaseVersionEntity getInfo(String id);
    /**
     * 删除系统版本管理操作
     * @param entity
     * @return
     */
    void delete(BaseVersionEntity entity);
    /**
     * 创建系统版本管理操作
     * @param baseVersionCrForm 主键
     * @return  boolean 是否成功
     */
    void create(BaseVersionCrForm baseVersionCrForm);
    /**
     * 更新系统版本管理操作
     * @param id 主键
     * @param baseVersionUpForm 主键
     * @return  boolean 是否成功
     */
    void update(String id, BaseVersionUpForm baseVersionUpForm);

    /**
     * 版本发布
     */
    ActionResult release(String id);

    /**
     * 发送通知
     * @param entity
     */
    void send(BaseVersionEntity entity);

    /**
     *  获取最新记录
     */
    BaseVersionEntity getVersion();

}
