package com.bringspring.system.base.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.base.entity.DbBackupEntity;
import com.bringspring.system.base.mapper.DbBackupMapper;
import com.bringspring.system.base.service.DbBackupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 数据备份
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class DbBackupServiceImpl extends ServiceImpl<DbBackupMapper, DbBackupEntity> implements DbBackupService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DataSourceModel dataSourceUtils;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<DbBackupEntity> getList(Pagination pagination) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        QueryWrapper<DbBackupEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().orderByAsc(DbBackupEntity::getSortCode);
        if (pagination.getKeyword() != null) {
            flag = true;
            queryWrapper.lambda().and(
                    t -> t.like(DbBackupEntity::getFileName, pagination.getKeyword())
                            .or().like(DbBackupEntity::getBackupDbName, pagination.getKeyword())
            );
        }
        //排序
        queryWrapper.lambda().orderByAsc(DbBackupEntity::getSortCode).orderByDesc(DbBackupEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(DbBackupEntity::getLastModifyTime);
        }
        Page<DbBackupEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<DbBackupEntity> iPage = this.page(page, queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public DbBackupEntity getInfo(String id) {
        QueryWrapper<DbBackupEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(DbBackupEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void delete(DbBackupEntity entity) {
        if (entity != null) {
            //删除文件
            FileUtil.deleteFile(configValueUtil.getDataBackupFilePath() + entity.getFileName());
            this.removeById(entity.getId());
            //删除文件
            UploadUtil.removeFile(configValueUtil.getFileType(), FileTypeEnum.DATABACKUP, entity.getFileName());
        }
    }

    @Override
    public void create(DbBackupEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setSortCode(RandomUtil.parses());
        entity.setCreatorUserId(userProvider.get().getUserId());
        this.save(entity);
    }
}
