package com.bringspring.system.external.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.emoji.EmojiUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.listener.DIngStream;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.service.impl.MyWxCpLinkedCorpServiceImpl;
import com.bringspring.system.external.util.ValidateCommonUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpAgentPerm;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpDepartment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

import static com.bringspring.system.external.constant.WxCpSysConfigConsts.TARGET_CHAR;
import static com.bringspring.system.message.util.SynThirdConsts.*;

/**
 * 企业微信-互联企业-获取接口信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2024/1/31 9:30
 */
@Slf4j
@Api(tags = "企业微信-互联企业", value = "WxCpLinkedCorp")
@RestController
@RequestMapping("/api/external/linkedCorp/{corpId}/{agentId}")
public class WxCpLinkedCorpController {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;

    @Autowired
    private DIngStream dIngStream;

    @Autowired
    WxCpConfiguration wxCpConfiguration;

    @Autowired
    ValidateCommonUtil validateCommonUtil;


    /**
     * 获取互联企业部门列表
     *
     * @return
     */
    @ApiOperation("企业微信【互联企业】获取互联企业部门列表")
    @GetMapping("/department/list")
    @DSTransactional
    @CacheEvict(value = "OrganizeCache", allEntries = true)
    public ActionResult linkedcorpDepartmentList(@PathVariable String corpId, @PathVariable Integer agentId) {
        UserInfo userInfo = userProvider.get();
        if (ObjectUtil.isEmpty(userInfo)) {
            return ActionResult.fail("获取当前登录用户信息失败");
        }
        final WxCpService wxCpService = wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail(String.format("未找到对应corpId=[%s]、agentId=[%d]的配置，请核实！", corpId, agentId));
        }

        MyWxCpLinkedCorpServiceImpl wxCpLinkedCorpService = new MyWxCpLinkedCorpServiceImpl();
        wxCpLinkedCorpService.setWxCpService(wxCpService);
        try {
            /**
             * 获取应用的可见范围
             */
            WxCpLinkedCorpAgentPerm linkedCorpAgentPerm = wxCpLinkedCorpService.getLinkedCorpAgentPerm();
            String[] userIdList; // 可见用户
            String[] agentPermList; // 可见组织或部门
            if (ObjectUtil.isNotEmpty(linkedCorpAgentPerm)) {
                userIdList = linkedCorpAgentPerm.getUserIdList();
                agentPermList = linkedCorpAgentPerm.getDepartmentIdList();
                if (ObjectUtil.isEmpty(agentPermList) || agentPermList.length == 0) {
                    return ActionResult.fail("可见组织为空，请核实企业微信管理后台应用配置！");
                }
            } else {
                return ActionResult.fail("获取应用的可见范围接口返回数据错误");
            }

            List<OrganizeEntity> organizeList = new ArrayList<>();
            List<SynThirdInfoEntity> synThirdInfoList = new ArrayList<>();
            for (String s : agentPermList) {
                /**
                 * 获取互联企业部门列表
                 */
                List<WxCpLinkedCorpDepartment> deptList =
                        wxCpLinkedCorpService.getLinkedCorpDepartmentList(s);
                if (deptList == null || deptList.size() == 0) {
                    return ActionResult.fail("获取互联企业部门列表接口数据为空");
                }
                deptList.stream().forEach(item -> {
                    String id = item.getDepartmentId();
                    String parentid = item.getParentId();
                    //组织数据
                    OrganizeEntity organizeEntity = new OrganizeEntity();
                    // 创建的部门id
                    organizeEntity.setId(id);
                    // 部门名称
                    organizeEntity.setFullName(item.getDepartmentName());
                    // 父部门id。根部门为0 替换为 根部门为-1
                    organizeEntity.setParentId("0".equals(parentid) ? "-1" : parentid);
                    // 机构分类。根据父部门id 为0或1的机构分类为公司
                    organizeEntity.setCategory("1".equals(parentid) || "0".equals(parentid) ? "company" : "department");
                    // 排序
                    organizeEntity.setSortCode(Long.valueOf(item.getOrder()));
                    organizeList.add(organizeEntity);

                    // THIRD_TYPE_QY：第三方工具类型(1:企业微信;2:钉钉)、DATA_TYPE_ORG：数据类型(1:组织(公司与部门);2:用户)
                    SynThirdInfoEntity synThirdInfoEntity =
                            synThirdInfoService.getInfoByThirdObjId(THIRD_TYPE_QY, DATA_TYPE_ORG, id);
                    if (null == synThirdInfoEntity) {
                        // 不存在 则创建。 “第三方工具的公司-部门-用户同步表模型”
                        synThirdInfoEntity = new SynThirdInfoEntity();
                        synThirdInfoEntity.setId(RandomUtil.uuId());
                    }
                    synThirdInfoEntity.setThirdObjectId(id); // 第三对象ID
                    synThirdInfoEntity.setSystemObjectId(id); // 系统对象ID
                    synThirdInfoEntity.setCropId(corpId); // 企业微信公司id
                    synThirdInfoEntity.setThirdType(Integer.valueOf(THIRD_TYPE_QY)); // 第三方类型(1:企业微信;2:钉钉)
                    synThirdInfoEntity.setDataType(Integer.valueOf(DATA_TYPE_ORG)); // 数据类型(1:组织(公司与部门);2:用户)
                    synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK); // 同步状态(0:未同步;1:同步成功;2:同步失败)
                    synThirdInfoEntity.setCreatorUserId(userInfo.getUserId()); // 创建人
                    synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate()); // 创建时间
                    synThirdInfoList.add(synThirdInfoEntity);

                });
            }
            if (organizeList.size() != 0 && synThirdInfoList.size() != 0) {
                /**
                 * 本地有的编辑，本地没有的新增 saveBatch
                 * 批量新增或编辑
                 */
                organizeService.saveOrUpdateBatch(organizeList);
                synThirdInfoService.saveOrUpdateBatch(synThirdInfoList);
                /**
                 * 机构编码为空的 设置机构编码
                 */
                // dIngStream.setOrganizeCode();
                /**
                 * 设置祖宗组织id
                 */
                dIngStream.setOrganizedTree();
                // 获取结果
                SynThirdTotal synThirdTotal = synThirdInfoService.getSynTotal(THIRD_TYPE_QY, DATA_TYPE_ORG);
                return ActionResult.success(synThirdTotal);
            } else {
                return ActionResult.fail("获取互联企业部门列表为空");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail("系统运行时异常：" + e);
        }
    }

    /**
     * 获取互联企业部门成员详情
     *
     * @return ignore
     */
    @ApiOperation("企业微信【互联企业】获取互联企业部门成员详情")
    @GetMapping("/user/list")
    @DSTransactional
    @CacheEvict(value = "UserCache", allEntries = true)
    public ActionResult linkedcorpUserList(@PathVariable String corpId, @PathVariable Integer agentId) {
        UserInfo userInfo = userProvider.get();
        if (ObjectUtil.isEmpty(userInfo)) {
            return ActionResult.fail("获取当前登录用户信息失败");
        }

        final WxCpService wxCpService = wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail(String.format("未找到对应corpId=[%s]、agentId=[%d]的配置，请核实！", corpId, agentId));
        }

        MyWxCpLinkedCorpServiceImpl wxCpLinkedCorpService = new MyWxCpLinkedCorpServiceImpl();
        wxCpLinkedCorpService.setWxCpService(wxCpService);
        try {
            /**
             * 获取应用的可见范围
             */
            WxCpLinkedCorpAgentPerm linkedCorpAgentPerm = wxCpLinkedCorpService.getLinkedCorpAgentPerm();
            String[] userIdList; // 可见用户
            String[] agentPermList; // 可见组织或部门
            if (ObjectUtil.isNotEmpty(linkedCorpAgentPerm)) {
                userIdList = linkedCorpAgentPerm.getUserIdList();
                agentPermList = linkedCorpAgentPerm.getDepartmentIdList();
                if (ObjectUtil.isEmpty(agentPermList) || agentPermList.length == 0) {
                    return ActionResult.fail("可见组织为空，请核实企业微信管理后台应用配置！");
                }
            } else {
                return ActionResult.fail("获取应用的可见范围接口返回数据错误");
            }
            // 初始化系统数据
            validateCommonUtil.initData();

            StringBuilder deptListMsg = new StringBuilder();
            StringBuilder userListMsg = new StringBuilder();
            List<UserEntity> userBatch = new ArrayList<>();
            List<SynThirdInfoEntity> synThirdInfoBatch = new ArrayList<>();
            Map<String, UserEntity> updateUserMap = new HashMap<>();
            Map<String, UserEntity> saveUserMap = new HashMap<>();
            Map<String, SynThirdInfoEntity> updateThirdMap = new HashMap<>();
            Map<String, SynThirdInfoEntity> saveThirdMap = new HashMap<>();
            List<PositionEntity> positionBatch = new ArrayList<>();
            Map<String, PositionEntity> savePositionMap = new HashMap<>();
            for (String s : agentPermList) {
                String agentPerm = s;
                /**
                 * 获取互联企业部门列表
                 */
                List<WxCpLinkedCorpDepartment> lcDeptList =
                        wxCpLinkedCorpService.getLinkedCorpDepartmentList(agentPerm);
                if (lcDeptList == null || lcDeptList.size() == 0) {
                    deptListMsg.append(agentPerm);
                    deptListMsg.append(":获取互联企业部门列表失败");
                    // 结束进入下一次循环
                    continue;
                }

                for (WxCpLinkedCorpDepartment d : lcDeptList) {
                    /**
                     * 获取互联企业部门成员详情
                     * departmentId：wh87896fbeb5dcdd15/1
                     */
                    String departmentId = d.getDepartmentId();  // 部门ID
                    departmentId = agentPerm.replaceFirst("/.*", TARGET_CHAR + departmentId);
                    List<MyWxCpLinkedCorpUser> lcUserList = wxCpLinkedCorpService.getLinkedCorpUserList(departmentId);
                    log.info("departmentId:" + departmentId);
                    log.info("lcUserList:" + lcUserList.toString());
                    if (lcUserList == null || lcUserList.size() == 0) {
                        userListMsg.append(departmentId);
                        userListMsg.append(":获取互联企业部门成员详情失败");
                        // 结束进入下一次循环
                        continue;
                    }
                    for (MyWxCpLinkedCorpUser qyuser : lcUserList) {
                        String userCorpId = qyuser.getCorpId();
                        String userid = qyuser.getUserId();
                        // 判断是不是为空,需要挨个判断
                        if (StringUtils.isEmpty(userCorpId) || StringUtils.isEmpty(userid)) {
                            // 结束进入下一次循环
                            continue;
                        }

                        String mobile = qyuser.getMobile();
                        String email = qyuser.getEmail();

                        UserEntity userEntity; // 系统用户
                        SynThirdInfoEntity synThirdInfoEntity; // 第三方记录表
                        /**
                         * 登录账户是否新增,默认false
                         */
                        boolean userIsNew = false;
                        /*
                        third_object_id第三对象ID
                        注意：这里约定，多例企业配置用user，互联企业配置用‘/’拼接corpid/userid.
                         */
                        String thirdObjid = userCorpId + TARGET_CHAR + userid;
                        synThirdInfoEntity = validateCommonUtil.getThirdEntityByThirdId(thirdObjid);
                        if (ObjectUtil.isNotEmpty(synThirdInfoEntity)) {// 第三方数据已同步
                            synThirdInfoEntity.setThirdObjectId(thirdObjid);
                            // system_object_id系统对象ID
                            String systemObjectId = synThirdInfoEntity.getSystemObjectId();

                            userEntity = validateCommonUtil.getUserEntityByUserid(systemObjectId);
                            if (ObjectUtil.isEmpty(userEntity)) {// 系统用户ID不存在
                                // 判断系统账号account是否存在
                                userEntity = validateCommonUtil.getUserEntity(userid, mobile, email);
                                if (ObjectUtil.isEmpty(userEntity)) {// 账号不存在
                                    /**
                                     *  登录账户是新增
                                     *  系统用户ID 和 账号 都不存在
                                     */
                                    userIsNew = true;
                                    userEntity = new UserEntity();
                                    userEntity.setId(RandomUtil.uuId());
                                    userEntity.setAccount(userid);
                                }
                            }
                        } else {
                            // 第三方数据未同步
                            synThirdInfoEntity = validateCommonUtil.newSynThirdInfoForWxUser(thirdObjid);

                            // 判断系统账号account是否存在
                            userEntity = validateCommonUtil.getUserEntity(userid, mobile, email);
                            if (ObjectUtil.isEmpty(userEntity)) {// 账号不存在
                                /**
                                 *  登录账户是新增
                                 *  未同步 且 账号不存在
                                 */
                                userIsNew = true;
                                userEntity = new UserEntity();
                                userEntity.setId(RandomUtil.uuId());
                                userEntity.setAccount(userid);
                            }
                        }

                        synThirdInfoEntity.setCropId(corpId);
                        synThirdInfoEntity.setSystemObjectId(userEntity.getId());

                        // 姓名
                        if (StringUtils.isNotEmpty(qyuser.getName())) {
                            // 去掉除汉字以外的字符
                            String name = StringUtils.stringFilter(EmojiUtil.removeAllEmojis(qyuser.getName()));
                            userEntity.setRealName(name);
                        }
                        // 手机
                        if (StringUtils.isNotEmpty(mobile)) {
                            userEntity.setMobilePhone(mobile);
                        }
                        // 电话
                        if (StringUtils.isNotEmpty(qyuser.getTelephone())) {
                            userEntity.setTelePhone(qyuser.getTelephone());
                        }
                        // 邮箱
                        if (StringUtils.isNotEmpty(email)) {
                            userEntity.setEmail(email);
                        }

                        // 部门和岗位设置
                        validateCommonUtil.setDeptAndPosition(qyuser, userEntity);
                        // 工号
                        userEntity.setCode(validateCommonUtil.getCode(qyuser));

                        if (userIsNew) {
                            /**
                             * 登录账户是新增,设置属性默认值
                             */
                            // 角色默认
                            userEntity.setRoleId(validateCommonUtil.getDefaultRoleId());
                            // 头像默认  微信企业没传
                            userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
                            // 性别默认 （1:男；3:女；3:保密）
                            userEntity.setGender(3);
                            // 有效标志默认
                            userEntity.setEnabledMark(1);
                            // 秘钥默认
                            userEntity.setSecretkey(RandomUtil.uuId());
                            // 是否管理员默认 0:否；1:是
                            userEntity.setIsAdministrator(0);
                            // 账户密码默认
                            userEntity.setPassword(userService.getDefaultPassword(userEntity.getSecretkey()));
                        }

                        if (userIsNew) {
                            /**
                             * 登录账户是新增
                             */
                            if (saveUserMap.containsKey(thirdObjid)) {
                                // 待保存的Map中存在, 合并到一个user
                                UserEntity aUser = saveUserMap.get(thirdObjid);
                                // 合并组织
                                validateCommonUtil.mergeDistinctOrganize(aUser, userEntity);
                                // 合并岗位
                                validateCommonUtil.mergeDistinctPosition(aUser, userEntity);

                                // 设置同步到系统用户表ID
                                synThirdInfoEntity.setSystemObjectId(aUser.getId());
                            } else {
                                // 放入待保存的Map
                                saveUserMap.put(thirdObjid, userEntity);
                            }

                            // 设置同步状态值
                            synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                            // 放入待保存的Map
                            saveThirdMap.put(thirdObjid, synThirdInfoEntity);
                        } else {
                            /**
                             * 登录账户否新增
                             */
                            // 系统用户systemObjectId或登录账户account已存在
                            if (updateUserMap.containsKey(thirdObjid)) {
                                // 待更新的Map中存在
                                UserEntity aUser = updateUserMap.get(thirdObjid);
                                // 合并组织
                                validateCommonUtil.mergeDistinctOrganize(aUser, userEntity);
                                // 合并岗位
                                validateCommonUtil.mergeDistinctPosition(aUser, userEntity);

                                // 设置同步到系统用户表ID
                                synThirdInfoEntity.setSystemObjectId(aUser.getId());
                            } else {
                                // 放入待更新的Map
                                updateUserMap.put(thirdObjid, userEntity);
                            }

                            // 设置同步状态值
                            synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                            // 放入待保存的Map
                            updateThirdMap.put(thirdObjid, synThirdInfoEntity);
                        }
                    }
                }
            }
            log.debug("===========同步企业微信用户信息反馈===========deptListMsg" + deptListMsg);
            log.debug("===========同步企业微信用户信息反馈===========userListMsg" + userListMsg);

            // 检查该 HashMap 是否含有元素
            if (!saveUserMap.isEmpty()) {
                Iterator<String> iterator = saveUserMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    UserEntity userEntity = saveUserMap.get(key);
                    // 岗位名称转换positionId
                    validateCommonUtil.convertPosition(savePositionMap, userEntity);

                    // 将新增用户 加入 批量保存或更新数据库列表
                    userBatch.add(userEntity);
                }
            }
//            if (!updateUserMap.isEmpty()) {
//                Iterator<String> iterator = updateUserMap.keySet().iterator();
//                while (iterator.hasNext()) {
//                    String key = iterator.next();
//                    UserEntity userEntity = updateUserMap.get(key);
//                    // 岗位名称转换positionId
//                    validateCommonUtil.convertPosition(savePositionMap, userEntity);
//
//                    // 保留用户关联信息
//                    validateCommonUtil.setUserRelation(userEntity);
//
//                    // 将更新用户 加入 批量保存或更新数据库列表
//                    userBatch.add(userEntity);
//                }
//            }
            if (!saveThirdMap.isEmpty()) {
                Iterator<String> iterator = saveThirdMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    synThirdInfoBatch.add(saveThirdMap.get(key));
                }
            }
//            if (!updateThirdMap.isEmpty()) {
//                Iterator<String> iterator = updateThirdMap.keySet().iterator();
//                while (iterator.hasNext()) {
//                    String key = iterator.next();
//                    synThirdInfoBatch.add(updateThirdMap.get(key));
//                }
//            }
            if (!savePositionMap.isEmpty()) {
                Iterator<String> iterator = savePositionMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    positionBatch.add(savePositionMap.get(key));
                }
            }
            if (StringUtils.isNotEmpty(userBatch) && StringUtils.isNotEmpty(synThirdInfoBatch)) {
                for (UserEntity entity : userBatch) {
                    // 组织 岗位 角色
                    userService.saveOrUpdateCommon(entity.getId(), entity);
                }
                positionService.saveOrUpdateBatch(positionBatch);
                userService.saveOrUpdateBatch(userBatch);
                synThirdInfoService.saveOrUpdateBatch(synThirdInfoBatch);
                //获取结果
                SynThirdTotal synThirdTotal = synThirdInfoService.getSynTotal(THIRD_TYPE_QY, DATA_TYPE_USER);
                return ActionResult.success(synThirdTotal);
            } else {
                return ActionResult.fail("获取用户数据为空");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail("系统运行时异常：" + e);
        }
    }
}
