package com.bringspring.system.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.service.MyWxCpLinkedCorpService;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpAgentPerm;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpDepartment;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpUser;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

import java.util.List;
import java.util.Map;

import static me.chanjar.weixin.cp.constant.WxCpApiPathConsts.LinkedCorp.*;

/**
 * 互联企业相关接口实现类
 * WxJava的WxCpLinkedCorpService不能用，所以写一个MyWxCpLinkedCorpService。
 *
 * @since 30/1/2024 9:57 PMs
 */
@Slf4j
public class MyWxCpLinkedCorpServiceImpl implements MyWxCpLinkedCorpService {
    WxCpService wxCpService;

    @Override
    public WxCpLinkedCorpAgentPerm getLinkedCorpAgentPerm() throws WxErrorException {
        final String url = this.wxCpService.getWxCpConfigStorage().getApiUrl(GET_PERM_LIST);
        JsonObject jsonObject = new JsonObject();
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        return WxCpGsonBuilder.create().fromJson(responseContent, WxCpLinkedCorpAgentPerm.class);
    }

    @Override
    public List<WxCpLinkedCorpDepartment> getLinkedCorpDepartmentList(String departmentId) throws WxErrorException {
        final String url = this.wxCpService.getWxCpConfigStorage().getApiUrl(GET_DEPARTMENT_LIST);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse(responseContent);

        return WxCpGsonBuilder.create().fromJson(tmpJson.get("department_list"),
                new TypeToken<List<WxCpLinkedCorpDepartment>>() {
                }.getType()
        );
    }
//    @Override
//    public List<WxCpLinkedCorpUser> getLinkedCorpUserList(String departmentId) throws WxErrorException {
//        final String url = this.wxCpService.getWxCpConfigStorage().getApiUrl(GET_USER_LIST);
//        JsonObject jsonObject = new JsonObject();
//        jsonObject.addProperty("department_id", departmentId);
//        String responseContent = this.wxCpService.post(url, jsonObject.toString());
//        JsonObject tmpJson = GsonParser.parse(responseContent);
//
//        return WxCpGsonBuilder.create().fromJson(tmpJson.get("userlist"),
//                new TypeToken<List<WxCpLinkedCorpUser>>() {
//                }.getType()
//        );
//    }

    @Override
    public List<MyWxCpLinkedCorpUser> getLinkedCorpUserList(String departmentId) throws WxErrorException {
        final String url = this.wxCpService.getWxCpConfigStorage().getApiUrl(GET_USER_LIST);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        JSONObject tmpJson = JSONObject.parseObject(responseContent);

        List<MyWxCpLinkedCorpUser> userlist = JsonUtil.getJsonToList(tmpJson.getString("userlist"),
                MyWxCpLinkedCorpUser.class);
        return userlist;
    }

//    @Override
//    public WxCpLinkedCorpUser getLinkedCorpUser(String userId) throws WxErrorException {
//        final String url = this.wxCpService.getWxCpConfigStorage().getApiUrl(GET_USER);
//        JsonObject jsonObject = new JsonObject();
//        jsonObject.addProperty("userid", userId);
//        String responseContent = this.wxCpService.post(url, jsonObject.toString());
//        JsonObject tmpJson = GsonParser.parse(responseContent);
//        return WxCpGsonBuilder.create().fromJson(tmpJson.get("user_info"),
//                new TypeToken<WxCpLinkedCorpUser>() {
//                }.getType()
//        );
//    }
    @Override
    public MyWxCpLinkedCorpUser getLinkedCorpUser(String userId) throws WxErrorException {
        final String url = this.wxCpService.getWxCpConfigStorage().getApiUrl(GET_USER);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());

        Map<String, Object> tmpJson = JsonUtil.stringToMap(responseContent);
        String user_info = String.valueOf(tmpJson.get("user_info"));
        MyWxCpLinkedCorpUser myWxCpLinkedCorpUser = JsonUtil.getJsonToBean(user_info, MyWxCpLinkedCorpUser.class);
        return myWxCpLinkedCorpUser;
    }

    @Override
    public List<WxCpLinkedCorpUser> getLinkedCorpSimpleUserList(String departmentId) throws WxErrorException {
        final String url = this.wxCpService.getWxCpConfigStorage().getApiUrl(GET_USER_SIMPLELIST);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse(responseContent);

        return WxCpGsonBuilder.create().fromJson(tmpJson.get("userlist"),
                new TypeToken<List<WxCpLinkedCorpUser>>() {
                }.getType()
        );
    }

    public void setWxCpService(WxCpService wxCpService) {
        this.wxCpService = wxCpService;
    }

}
