package com.bringspring.system.message.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 消息接收
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_MESSAGE_RECEIVE")
public class MessageReceiveEntity {
    /**
     * 收件主键
     */
    @TableId("ID")
    private String id;

    /**
     * 消息主键
     */
    @TableField("MESSAGE_ID")
    private String messageId;

    /**
     * 用户主键
     */
    @TableField("USER_ID")
    private String userId;

    /**
     * 是否阅读
     */
    @TableField("IS_READ")
    private Integer isRead;

    /**
     * 阅读时间
     */
    @TableField("READ_TIME")
    private Date readTime;

    /**
     * 阅读次数
     */
    @TableField("READ_COUNT")
    private Integer readCount;

    /**
     * 站内信息
     */
    @TableField("BODY_TEXT")
    private String bodyText;
}
