package com.bringspring.system.msgcenter.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 渠道类型枚举
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/23 17:45
 */
public enum ChannelTypeEnum {
    /**
     * 站内消息
     */
    SYS_MSG("1", "站内信"),
    /**
     * 发送邮件
     */
    MAIL_MSG("2", "电子邮箱"),
    /**
     * 发送短信
     */
    SMS_MSG("3", "短信"),
    /**
     * 钉钉消息
     */
    DING_MSG("4", "阿里钉钉"),
    /**
     * 企业微信
     */
    QY_MSG("5", "企业微信"),
    /**
     * 微信小程序
     */
    WX_MINIAPP("6", "微信小程序"),
    /**
     * 微信公众号
     */
    WX_MP("7", "微信公众号"),
    /**
     * webhook
     */
    WEBHOOK("8", "webhook");

    private String code;
    private String channel;

    ChannelTypeEnum(String code, String channel) {
        this.code = code;
        this.channel = channel;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    /**
     * 根据状态code获取枚举值
     *
     * @return
     */
    public static ChannelTypeEnum getByCode(String code) {
        for (ChannelTypeEnum status : ChannelTypeEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public static Map<String, ChannelTypeEnum> getAllToMap() {
        Map<String, ChannelTypeEnum> map = new HashMap<>();
        for (ChannelTypeEnum alarmType : values()) {
            map.put(alarmType.getCode(), alarmType);
        }
        return map;
    }
}
