package com.bringspring.system.msgcenter.model.mcmsgtemplate;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-07
 */
@Data
public class McMsgTemplateListVO {

    /**
     * 主键
     */
    private String id;


    /**
     * 名称
     **/
    @JsonProperty("fullName")
    private String fullName;


    /**
     * 编码
     **/
    @JsonProperty("enCode")
    private String enCode;


    /**
     * 模板类型
     **/
    @JsonProperty("templateType")
    private String templateType;


    /**
     * 消息来源
     **/
    @JsonProperty("messageSource")
    private String messageSource;


    /**
     * 消息渠道
     **/
    @JsonProperty("messageType")
    private String messageType;


    /**
     * 排序
     **/
    @JsonProperty("sortCode")
    private Integer sortCode;

    /**
     * 状态
     **/
    @JsonProperty("enabledMark")
    private String enabledMark;


    /**
     * 说明
     **/
    @JsonProperty("description")
    private String description;


    /**
     * 标题
     **/
    @JsonProperty("title")
    private String title;


    /**
     * 内容
     **/
    @JsonProperty("content")
    private String content;


    /**
     * 模板编号
     **/
    @JsonProperty("templateCode")
    private String templateCode;


    /**
     * 跳转方式
     **/
    @JsonProperty("wxSkip")
    private String wxSkip;


    /**
     * 关联小程序ID
     **/
    @JsonProperty("xcxAppId")
    private String xcxAppId;


    /**
     * 订阅类型
     **/
    @JsonProperty("subscriberType")
    private String subscriberType;


    /**
     * 创建时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("creatorTime")
    private Date creatorTime;


    /**
     * 创建用户
     **/
    @JsonProperty("creatorUserId")
    private String creatorUserId;


    /**
     * 修改时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("lastModifyTime")
    private Date lastModifyTime;


    /**
     * 修改用户
     **/
    @JsonProperty("lastModifyUserId")
    private String lastModifyUserId;


    /**
     * 删除时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("deleteTime")
    private Date deleteTime;


    /**
     * 删除用户
     **/
    @JsonProperty("deleteUserId")
    private String deleteUserId;


    /**
     * 有效标志
     **/
    @JsonProperty("deleteMark")
    private String deleteMark;


}