package com.bringspring.system.msgcenter.service.chain;

import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 构建处理链
 */
@Component
public class FilterChain {
    private final List<FilterProcessor> processors;

    public FilterChain(List<FilterProcessor> processors) {
        this.processors = processors;
    }

    public void process(SendMessageContext context) {
        List<McTaskMsgReceiveEntity> currentValid = context.getReceiveList();

        for (FilterProcessor processor : processors) {
            FilterResult result = processor.process(context);
            context.getInvalidList().addAll(result.getInvalid());
            currentValid = result.getValid();

            if (currentValid.isEmpty()) break;
            context.setValidList(currentValid);
        }

        context.setValidList(currentValid);
    }
}
