package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgSendTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.mapper.McMsgSendTemplateMapper;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.bringspring.system.msgcenter.constant.Constants.Uniqueness;

/**
 * mc_msg_send_template
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-12
 */
@Service
public class McMsgSendTemplateServiceImpl extends ServiceImpl<McMsgSendTemplateMapper, McMsgSendTemplateEntity> implements McMsgSendTemplateService {

    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    @Override
    public boolean checkTemplateUnique(List<McMsgSendTemplateModel> templateList) {

        //根据templateId和accountConfigId字段进行分组
        List<String> uniqueList =
                templateList.stream().collect(Collectors.groupingBy(t -> t.getTemplateId() + t.getAccountConfigId(),
                        Collectors.counting())).entrySet().stream().filter(e -> e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        uniqueList.forEach(p -> System.out.println(p));

        if (CollectionUtil.isNotEmpty(uniqueList)) {
            // 存在重复,返回false
            return Uniqueness.NOT_UNIQUE;
        }
        return Uniqueness.UNIQUE;
    }


    @Override
    public McMsgSendTemplateModel getModel(String id) {
        QueryWrapper<McMsgSendTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getId, id);
        queryWrapper.last("limit 1");
        McMsgSendTemplateEntity one = this.getOne(queryWrapper);
        McMsgSendTemplateModel model = JsonUtil.getJsonToBean(one, McMsgSendTemplateModel.class);
        if (ObjectUtil.isNotNull(model)) {
            //子表
            McMsgTemplateEntity templateInfo = mcMsgTemplateService.getInfo(model.getTemplateId());
            model.setTemplateName(templateInfo != null ? templateInfo.getFullName() : null);
            model.setTemplateEnCode(templateInfo != null ? templateInfo.getEnCode() : null);
            McMsgAccountEntity accountInfo = mcMsgAccountService.getInfo(model.getAccountConfigId());
            model.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
            model.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
        }
        return model;
    }

    @Override
    public long getCountByTemplateId(String templateId) {
        LambdaQueryWrapper<McMsgSendTemplateEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgSendTemplateEntity::getTemplateId, templateId);
        return this.count(queryWrapper);
    }
    @Override
    public long getCountByAccountConfigId(String accountConfigId) {
        LambdaQueryWrapper<McMsgSendTemplateEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgSendTemplateEntity::getAccountConfigId, accountConfigId);
        return this.count(queryWrapper);
    }
}